/*
 *      INSTALL.CMD - V1.07 - NOSA Administrator - C.Langanke@TeamOS2.DE - 1999
 *
 *     Syntax: install
 */
/* First comment is used as help text */

 SIGNAL ON HALT

 TitleLine = STRIP(SUBSTR(SourceLine(2), 3));
 PARSE VAR TitleLine CmdName'.CMD 'Info
 Title     = CmdName Info

 env          = 'OS2ENVIRONMENT';
 TRUE         = (1 = 1);
 FALSE        = (0 = 1);
 CrLf         = "0d0a"x;
 Redirection  = '> NUL 2>&1';
 '@ECHO OFF'

 /* OS/2 errorcodes */
 ERROR.NO_ERROR           =  0;
 ERROR.INVALID_FUNCTION   =  1;
 ERROR.FILE_NOT_FOUND     =  2;
 ERROR.PATH_NOT_FOUND     =  3;
 ERROR.ACCESS_DENIED      =  5;
 ERROR.NOT_ENOUGH_MEMORY  =  8;
 ERROR.INVALID_FORMAT     = 11;
 ERROR.INVALID_DATA       = 13;
 ERROR.NO_MORE_FILES      = 18;
 ERROR.WRITE_FAULT        = 29;
 ERROR.READ_FAULT         = 30;
 ERROR.GEN_FAILURE        = 31;
 ERROR.INVALID_PARAMETER  = 87;

 GlobalVars = 'Title CmdName env TRUE FALSE Redirection ERROR.';
 SAY;

 /* show help */
 ARG Parm .
 IF (POS('?', Parm) > 0) THEN
 DO
    rc = ShowHelp();
    EXIT(ERROR.INVALID_PARAMETER);
 END;

 /* load RexxUtil */
 CALL RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
 CALL SysLoadFuncs;

 /* Defaults */
 GlobalVars          = GlobalVars '';
 IniAppName          = 'NOSAADM';
 IniAppName_Comments = 'NOSAADM_COMMENTS';
 rc = ERROR.NO_ERROR;
 ErrMsg = '';

 PromptHostname      = 'hostname for the Netlabs Open Source Archive server'CRLF;
 PromptArchiveRoot   = 'root directory of the Netlabs Open Source Archive'CRLF;
 PromptWorkRoot      = 'root directory for working directories on your computer'CRLF;
 PromptSnapshotRoot  = 'root directory for snapshot zipfiles on your computer'CRLF;
 PromptBackupRoot    = 'root directory for backup zipfiles on your computer'CRLF;
 PromptInitCommand   = 'Init Command for project windows (optional)'CRLF;
 PromptUser          = 'CVS Administrator User Id'CRLF;
 PromptHome          = 'CVS home directory'CRLF;

 DO UNTIL (TRUE)

    /* read variables */
    CvsHostname      = ReadIniValue(, IniAppName, 'CVS_HOSTNAME');
    CvsExe           = ReadIniValue(, IniAppName, 'CVS_EXE');
    CvsBinRoot       = ReadIniValue(, IniAppName, 'CVS_BINROOT');
    CvsArchiveRoot   = ReadIniValue(, IniAppName, 'CVS_ARCHIVEROOT',  'c:\netlabs.cvs');
    CvsWorkRoot      = ReadIniValue(, IniAppName, 'CVS_WORKROOT',     'c:\netlabs.src');
    CvsSnapshotRoot  = ReadIniValue(, IniAppName, 'CVS_SNAPSHOTROOT', 'c:\netlabs.snap');
    CvsBackupRoot    = ReadIniValue(, IniAppName, 'CVS_BACKUPROOT',   'c:\netlabs.bak');
    CvsInitCommand   = ReadIniValue(, IniAppName, 'CVS_INITCOMMAND');
    CvsUser          = ReadIniValue(, IniAppName, 'CVS_USER', VALUE('USER',,env));
    CvsHome          = ReadIniValue(, IniAppName, 'CVS_HOME', VALUE('HOME',,env));
    fCvsInPath       = (SysSearchPath('PATH', 'CVS.EXE') \= '');

    /* set some defaults */
    IF (Cvshome     = '') THEN CvsHome     = 'c:\home';

    DO WHILE (TRUE)
       'CLS';
       SAY;
       SAY Title
       SAY;
       SAY 'Please enter/modify the following values:';
       SAY '- press Enter if the default value in brackets applies';
       SAY '- press Ctrl-Break and Enter to abort';

       CvsHostname     = STRIP(PullVariable( CvsHostname,     PromptHostname));
       CvsArchiveRoot  = STRIP(PullVariable( CvsArchiveRoot,  PromptArchiveRoot));
       CvsWorkRoot     = STRIP(PullVariable( CvsWorkRoot,     PromptWorkRoot));
       CvsSnapshotRoot = STRIP(PullVariable( CvsSnapshotRoot, PromptSnapshotRoot));
       CvsBackupRoot   = STRIP(PullVariable( CvsBackupRoot,   PromptBackupRoot));
       CvsHome         = STRIP(PullVariable( CvsHome,         PromptHome));
       CvsInitCommand  = STRIP(PullVariable( CvsInitCommand,  PromptInitCommand));
       CvsUser         = STRIP(PullVariable( CvsUser,         PromptUser));

       /* check cvs */
       IF (\fCvsInPath) THEN
       DO
          CvsBinRoot  = STRIP(PullVariable( CvsBinRoot,      'Directory of CVS installation'CRLF));
          CvsExe      = CvsBinRoot'\bin\cvs.exe';
       END;
       ELSE
       DO
          IF (CvsExe = '') THEN
             CvsExe = SysSearchPath('PATH', 'CVS.EXE');
       END;

       IF (TRUE) THEN /* ProceedWith('Are these values correct')) THEN */
       DO
          MissingVar = '';
          SELECT
             WHEN (CvsHostname = '')      THEN MissingVar = PromptHostname;
             WHEN (CvsArchiveRoot = '')   THEN MissingVar = PromptArchiveRoot;
             WHEN (CvsWorkRoot = '')      THEN MissingVar = PromptWorkRoot;
             WHEN (CvsSnapshotRoot = '')  THEN MissingVar = PromptSnapshotRoot;
             WHEN (CvsBackupRoot = '')    THEN MissingVar = PromptBackupRoot;
             WHEN (CvsUser = '')          THEN MissingVar = PromptUser
             WHEN (CvsHome = '')          THEN MissingVar = PromptHome;
             OTHERWISE NOP;
          END;

          IF (MissingVar \= '') THEN
          DO
             SAY CmdName': Error: The value for the';
             SAY ' "'MissingVar'"';
             SAY 'may not be empty.';
             'PAUSE'
             ITERATE;
          END;

          /* check Cvs bin */
          IF (\fCvsInPath) THEN
             IF (\FileExist( CvsBinRoot'\BIN\CVS.EXE')) THEN
             DO
                SAY CmdName': Error: CVS.EXE not found in' CvsBinRoot'\bin';
                'PAUSE'
                ITERATE;
             END;

          /* all values ok */
          LEAVE;
       END;

    END;

    /* write new values */
    IF (\fCvsInPath) THEN
       rcx = SysIni(, IniAppName, 'CVS_BINROOT', CvsBinRoot);

    rcx = SysIni(, IniAppName, 'CVS_HOSTNAME',     CvsHostname);
    rcx = SysIni(, IniAppName, 'CVS_EXE',          CvsExe);
    rcx = SysIni(, IniAppName, 'CVS_ARCHIVEROOT',  CvsArchiveRoot);
    rcx = SysIni(, IniAppName, 'CVS_WORKROOT',     CvsWorkRoot);
    rcx = SysIni(, IniAppName, 'CVS_SNAPSHOTROOT', CvsSnapshotRoot);
    rcx = SysIni(, IniAppName, 'CVS_BACKUPROOT',   CvsBackupRoot);
    rcx = SysIni(, IniAppName, 'CVS_INITCOMMAND',  CvsInitCommand);
    rcx = SysIni(, IniAppName, 'CVS_USER',         CvsUser);
    rcx = SysIni(, IniAppName, 'CVS_HOME',         CvsHome);

    /* create directories */
    rcx = MakeCvsPath( CvsArchiveRoot);
    rcx = MakeCvsPath( CvsSnapshotRoot);
    rcx = MakeCvsPath( CvsBackupRoot);
    rcx = MakeCvsPath( CvsWorkRoot);
    rcx = MakeCvsPath( CvsHome);

    /* set comment chars for source files */
    /* extensions must be written in lower case here !!! */
    SAY;
    CALL CHAROUT, 'Schreibe Dateitypenliste ... ';
    rcx = SysIni(, IniAppName_Comments, '.asm', ';');
    rcx = SysIni(, IniAppName_Comments, '.c',   '/*'"00"x'*/');
    rcx = SysIni(, IniAppName_Comments, '.cc',  '//');
    rcx = SysIni(, IniAppName_Comments, '.cmd', ':');     /* REXX scripts are handled in cvsenv.cmd */
    rcx = SysIni(, IniAppName_Comments, '.cpp', '/*'"00"x'*/');
    rcx = SysIni(, IniAppName_Comments, '.dlg', '/*'"00"x'*/');
    rcx = SysIni(, IniAppName_Comments, '.h',   '/*'"00"x'*/');
    rcx = SysIni(, IniAppName_Comments, '.hh',  '/*'"00"x'*/');
    rcx = SysIni(, IniAppName_Comments, '.hpp', '/*'"00"x'*/');
    rcx = SysIni(, IniAppName_Comments, '.inc', ';');
    rcx = SysIni(, IniAppName_Comments, '.mak', '#');     /* "makefile" is handled in cvsenv.cmd */
    rcx = SysIni(, IniAppName_Comments, '.rc',  '/*'"00"x'*/');
    rcx = SysIni(, IniAppName_Comments, '.rc',  '/*'"00"x'*/');
    rcx = SysIni(, IniAppName_Comments, '.txt', ';');
    SAY 'Ok.';

 END;

 EXIT( rc);

/* ------------------------------------------------------------------------- */
HALT:
 SAY;
 SAY 'Interrupted by user.';
 EXIT(ERROR.GEN_FAILURE);

/* ------------------------------------------------------------------------- */
ShowHelp: PROCEDURE EXPOSE (GlobalVars)

 SAY Title;
 SAY;

 PARSE SOURCE . . ThisFile

 DO i = 1 TO 3
    rc = LINEIN(ThisFile);
 END;

 ThisLine = LINEIN(Thisfile);
 DO WHILE (ThisLine \= ' */')
    SAY SUBSTR(ThisLine, 7);
    ThisLine = LINEIN(Thisfile);
 END;

 rc = LINEOUT(Thisfile);

 RETURN('');

/* ------------------------------------------------------------------------- */
FileExist: PROCEDURE
 PARSE ARG FileName

 RETURN(STREAM(Filename, 'C', 'QUERY EXISTS') > '');

/* ========================================================================= */
ReadIniValue: PROCEDURE
PARSE ARG IniFile, IniAppname, IniKeyName, Default

 IniValue = SysIni(IniFile, IniAppname, IniKeyName);
 IF (IniValue = 'ERROR:') THEN
    IniValue = '';

 IF ((IniValue \= '') & (RIGHT(IniValue, 1) = "00"x)) THEN
    IniValue = LEFT( IniValue, LENGTH( IniValue) - 1);

 IF (IniValue = '') THEN
    IniValue = Default;

 RETURN( IniValue);

/* ------------------------------------------------------------------------- */
PullVariable: PROCEDURE
 PARSE ARG Default, Message

 SAY;
 CALL CHAROUT, Message '['Default'] : ';
 PARSE PULL PullVar;
 IF (LENGTH(PullVar) > 0) THEN
    RETURN(PullVar);
 ELSE
    RETURN(Default);

/* ------------------------------------------------------------------------- */
ProceedWith: PROCEDURE
 PARSE ARG Prompt

 ResponseKeys  = 'Y N A R I'; /* SysGetMessage(0); */
 Yes           = WORD(ResponseKeys, 1);
 No            = WORD(ResponseKeys, 2);
 ch            = ' ';
 ValidResponse = Yes||No;

 SAY;
 CALL CHAROUT ,Prompt '('Yes'/'No') '
 DO WHILE (POS(ch, ValidResponse) = 0)
    ch = SysGetKey('NOECHO');
    ch = TRANSLATE(ch);
    IF (POS(ch, ValidResponse) = 0) THEN BEEP(800, 200);
 END;
 SAY;
 SAY;
 RETURN(ch = Yes);

/* ------------------------------------------------------------------------- */
DirExist: PROCEDURE
 PARSE ARG Dirname

 IF (Dirname = '') THEN
    RETURN(0);

 /* use 'QUERY EXISTS' with root directories (???) */
 IF (RIGHT(DirName, 2) = ':\') THEN
   RETURN(STREAM(Dirname, 'C', 'QUERY EXISTS') \= '');

 /* query other directories this way */
 IF ((STREAM(Dirname, 'C', 'QUERY EXISTS') = '') &,
     (STREAM(Dirname, 'C', 'QUERY DATETIME') \= '')) THEN
    RETURN(1);
 ELSE
    RETURN(0);

/* ========================================================================= */
MakeCvsPath: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG PathName

 IF (DirExist( CvsArchiveRoot)) THEN
    RETURN(ERROR.NO_ERROR);

 PARSE SOURCE . . CallName
 FileName = SUBSTR( CallName, LASTPOS( '\', CallName) + 1);
 'XCOPY' CallName PathName'\' Redirection;
 rcx = SysFileDelete( PathName'\'FileName);
 RETURN( rc);

