/*
 *      CVSWPS.CMD - V1.07 - NOSA Administrator - C.Langanke@TeamOS2.DE - 1999
 *
 *      Syntax: CVSWPS
 *
 *      Creates WPS folder with program objects for access
 *      to the Netlabs Open Source Archive with CVS.
 *
 *      The created program objects require cvsenv.cmd.
 */
/* First comment is used as help text */

 SIGNAL ON HALT

 TitleLine = STRIP(SUBSTR(SourceLine(2), 3));
 PARSE VAR TitleLine CmdName'.CMD 'Info
 Title     = CmdName Info

 env          = 'OS2ENVIRONMENT';
 TRUE         = (1 = 1);
 FALSE        = (0 = 1);
 Redirection  = '> NUL 2>&1';
 '@ECHO OFF'

 /* OS/2 errorcodes */
 ERROR.NO_ERROR           =  0;
 ERROR.INVALID_FUNCTION   =  1;
 ERROR.FILE_NOT_FOUND     =  2;
 ERROR.PATH_NOT_FOUND     =  3;
 ERROR.ACCESS_DENIED      =  5;
 ERROR.NOT_ENOUGH_MEMORY  =  8;
 ERROR.INVALID_FORMAT     = 11;
 ERROR.INVALID_DATA       = 13;
 ERROR.NO_MORE_FILES      = 18;
 ERROR.WRITE_FAULT        = 29;
 ERROR.READ_FAULT         = 30;
 ERROR.GEN_FAILURE        = 31;
 ERROR.INVALID_PARAMETER  = 87;
 ERROR.ENVVAR_NOT_FOUND   = 203;

 GlobalVars = 'Title CmdName env TRUE FALSE Redirection ERROR.';
 SAY;

 /* show help */
 ARG Parm .
 IF (POS('?', Parm) > 0) THEN
 DO
    rc = ShowHelp();
    EXIT(ERROR.INVALID_PARAMETER);
 END;

 /* Defaults */
 GlobalVars = GlobalVars '';
 IniAppName = 'NOSAADM';
 rc = ERROR.NO_ERROR;
 ErrorMsg   = '';
 CallDir    = GetCalldir();
 IconDir    = CallDir'\ico';
 fIsWarp4    = (SysOS2Ver() >= 2.40);
 IF (fIsWarp4) THEN
    FolderIcons = 'ICONFILE='IconDir'\FOLDER4.ICO;ICONNFILE=1,'IconDir'\FOLDER4O.ICO'
 ELSE
    FolderIcons = 'ICONFILE='IconDir'\FOLDER3.ICO;ICONNFILE=1,'IconDir'\FOLDER3O.ICO'


 DO UNTIL (TRUE)

    /* read enviroment */
    CvsArchiveRoot     = ReadIniValue(, IniAppName, 'CVS_ARCHIVEROOT');
    CvsWorkRoot        = ReadIniValue(, IniAppName, 'CVS_WORKROOT');
    CvsSnapshotRoot    = ReadIniValue(, IniAppName, 'CVS_SNAPSHOTROOT');
    CvsBackupRoot      = ReadIniValue(, IniAppName, 'CVS_BACKUPROOT');
    IF (CvsArchiveRoot = '') THEN
    DO
       ErrorMsg = 'Error: the root directory of the Netlabs Open Source Archive is not specified';
       rc = ERROR.ENVVAR_NOT_FOUND
       LEAVE;
    END;

    /* search working directories */
    Filename = CvsArchiveRoot'\CVSROOT';
    Options  = 'ODS';
    rc = SysFileTree(FileName, 'ArchiveDir.', Options);
    IF (rc \= ERROR.NO_ERROR) THEN
    DO
       ErrorMsg = 'Error in SysFileTree: not enough memory.';
       rc = ERROR.NOT_ENOUGH_MEMORY;
       LEAVE;
    END;

    /* isolate archvie names */
    DO i = 1 TO ArchiveDir.0
       PathWords = TRANSLATE( ArchiveDir.i, ' ', '\');
       ArchiveDir.i = WORD( PathWords, WORDS( PathWords) - 1);
    END;

    /* create/update folder */
    HelpPage = 'HELPLIBRARY='CallDir'\NOSAADM.HLP;HELPPANEL';
    rcx = SysCreateObject( 'WPFolder',  'OS/2 Netlabs^Open Source Archive^Administration',  '<WP_DESKTOP>',             HelpPage'=3;ALWAYSSORT=YES;DEFAULTSORT=1;CCVIEW=NO;'FolderIcons';OBJECTID=<NETLABS_NOSAADM_FOLDER>;', 'U');
    rcx = SysCreateObject( 'WPProgram', 'Create new project archive',                       '<NETLABS_NOSAADM_FOLDER>', HelpPage'=2;PROGTYPE=WINDOWABLEVIO;EXENAME='CallDir'\CVSENV.CMD;PARAMETERS=[Neues Projekt:] $INIT;ICONFILE='IconDir'\ADD.ICO;OBJECTID=<NETLABS_NOSAADM_NEWPROJECT>;', 'U');
    rcx = SysCreateObject( 'WPProgram', 'Refresh this folder',                              '<NETLABS_NOSAADM_FOLDER>', HelpPage'=1;PROGTYPE=WINDOWABLEVIO;EXENAME='CallDir'\CVSWPS.CMD;ICONFILE='IconDir'\rebuild.ico;OBJECTID=<NETLABS_NOSAADM_REFRESH>;', 'U');
    rcx = SysCreateObject( 'WPShadow',  'Dummy',                                            '<NETLABS_NOSAADM_FOLDER>', 'SHADOWID=<CVS_FOLDER>;OBJECTID=<CVS_FOLDER_SHADOW>;', 'U');
    rcx = SysCreateObject( 'WPShadow',  'Dummy',                                            '<NETLABS_NOSAADM_FOLDER>', 'SHADOWID='CvsArchiveRoot';OBJECTID=<NETLABS_NOSAADM_ARCHIVEROOT_SHADOW>;', 'U');

    IF (CvsWorkRoot \= '') THEN
       rcx = SysCreateObject( 'WPShadow',  'Dummy',                                         '<NETLABS_NOSAADM_FOLDER>', 'SHADOWID='CvsWorkRoot';OBJECTID=<NETLABS_NOSAADM_WORKROOT_SHADOW>;', 'U');
    ELSE
       rcx = SysDestroyObject( '<NETLABS_NOSAADM_WORKROOT_SHADOW>;');

    IF (CvsSnapshotRoot \= '') THEN
       rcx = SysCreateObject( 'WPShadow',  'Dummy',                                         '<NETLABS_NOSAADM_FOLDER>', 'SHADOWID='CvsSnapshotRoot';OBJECTID=<NETLABS_NOSAADM_SNAPSHOTROOT_SHADOW>;', 'U');
    ELSE
       rcx = SysDestroyObject( '<NETLABS_NOSAADM_SNAPSHOTROOT_SHADOW>;');

    IF (CvsBackupRoot \= '') THEN
       rcx = SysCreateObject( 'WPShadow',  'Dummy',                                         '<NETLABS_NOSAADM_FOLDER>', 'SHADOWID='CvsBackupRoot';OBJECTID=<NETLABS_NOSAADM_BACKUPROOT_SHADOW>;', 'U');
    ELSE
       rcx = SysDestroyObject( '<NETLABS_NOSAADM_BACKUPROOT_SHADOW>;');

    /* create window objects */
    IdBase = '<NETLABS_NOSAADM_#';
    IdBaseLen = LENGTH(IdBase);
    ArchiveObjects = '';
    DO i = 1 TO ArchiveDir.0
       ThisObject = IdBase''TRANSLATE(ArchiveDir.i)'>';
       rcx = SysCreateObject( 'WPProgram', ArchiveDir.i'^Administrator^OS/2 Window' , '<NETLABS_NOSAADM_FOLDER>', HelpPage'=4;PROGTYPE=WINDOWABLEVIO;EXENAME=*;PARAMETERS=/K 'CallDir'\CVSENV.CMD' ArchiveDir.i';STARTUPDIR='CvsArchiveRoot'\'ArchiveDir.i';OBJECTID='ThisObject';', 'U');
       ArchiveObjects = ArchiveObjects ThisObject;
    END;

    /* delete obsolete objects */
    rcx  = SysIni(, 'PM_Workplace:Location', 'ALL:', 'Objects.');
    IF (rc \= 'ERROR:') THEN
    DO i = 1 TO Objects.0
       IF (LEFT( Objects.i, IdBaseLen) = IdBase) THEN
          IF ( WORDPOS( Objects.i, ArchiveObjects) = 0) THEN
             rcx = SysDestroyObject( Objects.i);
    END;

    /* bring folder to foreground */
    rcx = SysOpenObject( '<NETLABS_NOSAADM_FOLDER>', 'DEFAULT', 1);
    rcx = SysOpenObject( '<NETLABS_NOSAADM_FOLDER>', 'DEFAULT', 1);

 END;

 /* exit */
 IF (rc \= ERROR.NO_ERROR) THEN
 DO
    SAY CmdName': Error:' ErrorMsg;
    'PAUSE'
 END;
 EXIT( rc);

/* ------------------------------------------------------------------------- */
HALT:
 SAY;
 SAY 'Interrupted by user.';
 EXIT(ERROR.GEN_FAILURE);

/* ------------------------------------------------------------------------- */
ShowHelp: PROCEDURE EXPOSE (GlobalVars)

 SAY Title;
 SAY;

 PARSE SOURCE . . ThisFile

 DO i = 1 TO 3
    rc = LINEIN(ThisFile);
 END;

 ThisLine = LINEIN(Thisfile);
 DO WHILE (ThisLine \= ' */')
    SAY SUBSTR(ThisLine, 7);
    ThisLine = LINEIN(Thisfile);
 END;

 rc = LINEOUT(Thisfile);

 RETURN('');


/* ------------------------------------------------------------------------- */
GetCalldir: PROCEDURE
PARSE SOURCE . . CallName
 CallDir = FILESPEC('Drive', CallName)||FILESPEC('Path', CallName);
 RETURN(LEFT(CallDir, LENGTH(CallDir) - 1));

/* ========================================================================= */
ReadIniValue: PROCEDURE
PARSE ARG IniFile, IniAppname, IniKeyName

 IniValue = SysIni(IniFile, IniAppname, IniKeyName);
 IF (IniValue = 'ERROR:') THEN
    IniValue = '';

 IF ((IniValue \= '') & (RIGHT(IniValue, 1) = "00"x)) THEN
    IniValue = LEFT( IniValue, LENGTH( IniValue) - 1);

 RETURN( IniValue);

