/*
 *      CVSSEC.CMD - V1.07 - NOSA Administrator - C.Langanke@TeamOS2.DE - 1999
 *
 *     Syntax: cvssec CHECKCOMMIT|CHECKTAG parms...
 *
 *     cvssec is a filter to be specified in $CVSROOT/CVSROOT/commitinfo
 *     and $CVSROOT/CVSROOT/taginfo and checks, wether a commit or
 *     tag is allowed for a writer. The user is read from the environment
 *     variable $USER set by the pserver.
 *
 *     If write is allowed, this script returns rc=0, else != 0.
 *
 *     NOTE: The file $CVSROOT/CVSROOT/writers or readers should be used in
 *     order to specify those persons, who may (not) change anything in the
 *     archive.
 */
/* First comment is used as help text */

 SIGNAL ON HALT
 TitleLine = STRIP(SUBSTR(SourceLine(2), 3));
 PARSE VAR TitleLine CmdName'.CMD 'Info
 Title     = CmdName Info

 env          = 'OS2ENVIRONMENT';
 TRUE         = (1 = 1);
 FALSE        = (0 = 1);
 Redirection  = '> NUL 2>&1';
 CrLf         = "0d0a"x;
 '@ECHO OFF'

 /* OS/2 errorcodes */
 ERROR.NO_ERROR           =  0;
 ERROR.INVALID_FUNCTION   =  1;
 ERROR.FILE_NOT_FOUND     =  2;
 ERROR.PATH_NOT_FOUND     =  3;
 ERROR.ACCESS_DENIED      =  5;
 ERROR.NOT_ENOUGH_MEMORY  =  8;
 ERROR.INVALID_FORMAT     = 11;
 ERROR.INVALID_DATA       = 13;
 ERROR.NO_MORE_FILES      = 18;
 ERROR.WRITE_FAULT        = 29;
 ERROR.READ_FAULT         = 30;
 ERROR.GEN_FAILURE        = 31;
 ERROR.INVALID_PARAMETER  = 87;
 ERROR.ENVVAR_NOT_FOUND   = 203;

 GlobalVars = 'Title CmdName env TRUE FALSE Redirection ERROR.';
 SAY;

 /* show help */
 ARG Parm .
 IF ((Parm = '') | (POS('?', Parm) > 0)) THEN
 DO
    rc = ShowHelp();
    EXIT(ERROR.INVALID_PARAMETER);
 END;

 /* load RexxUtil */
 CALL RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
 CALL SysLoadFuncs;

 /* Defaults */
 GlobalVars     = GlobalVars 'CvsRoot CvsUser WriteInfoFile';
 fWriteAllowed  = FALSE;
 fCheckTag      = FALSE;
 Action         = ':';

 rc = ERROR.NO_ERROR;

 DO UNTIL (TRUE)

    /* -------------------------------------------------------------- */

    /* read some vars being filled by the cvs pserver */
    CvsRoot = VALUE('CVSROOT',,env);
    PARSE VAR CvsRoot ':local:'CvsRoot
    WriteInfoFile = dosslash(CvsRoot'\CVSROOT\writeinfo');
    LogFile       = dosslash(CvsRoot'\CVSROOT\writeinfo.log');
    CvsUser = VALUE('USER',,env);

    /* if environment is not correct, abort with error */
    IF (CvsRoot = '') THEN
    DO
       SAY Title;
       SAY CmdName': environment variable CVSROOT not set.'
       SAY;
       EXIT(ERROR.ENVVAR_NOT_FOUND);
    END;
    IF (CvsUser = '') THEN
    DO
       SAY Title;
       SAY CmdName': environment variable USER not set.'
       SAY;
       EXIT(ERROR.ENVVAR_NOT_FOUND);
    END;

    /* does writeinfo file exist ? If not, do nothing ! */
    IF (\FileExist( WriteInfoFile)) THEN
       RETURN(0);

    /* get command line parms */
    /* PARSE ARG does not work here well, use ARG() to emulate */
    Parms = '';
    DO i = 1 TO ARG()
       Parms = Parms ARG(i);
    END;
    Parms = STRIP(Parms);

    Action = STRIP(TRANSLATE(WORD( Parms, 1)));
    SELECT
       WHEN (Action = 'CHECKCOMMIT') THEN
       DO
          Action = 'commit:';
          fWriteAllowed = CheckCommitAllowed( Parms);
       END;
   
       WHEN (Action = 'CHECKTAG') THEN
       DO
          fWriteAllowed = CheckTagAllowed( Parms);
          Action = 'tag ('CvsTagOperation '"'CvsTagName'"):';
       END;
    END;

 END;

 IF (FileExist( Logfile)) THEN
 DO
    IF (fWriteAllowed) THEN
       LogLine = '0:' Action 'in' CvsDirectory 'allowed for:' CvsUser;
    ELSE
       LogLine = '#:' Action 'in' CvsDirectory 'permitted for:' CvsUser;
    rc = LINEOUT( Logfile, LogLine);
    rc = LINEOUT( Logfile);
 END;
 EXIT( \fWriteAllowed); /* 0: commit allowed; \0: commit not allowed */


/* ------------------------------------------------------------------------- */
HALT:
 SAY;
 SAY 'Interrupted by user.';
 EXIT(ERROR.GEN_FAILURE);

/* ------------------------------------------------------------------------- */
ShowHelp: PROCEDURE EXPOSE (GlobalVars)

 SAY Title;
 SAY;

 PARSE SOURCE . . ThisFile
 DO i = 1 TO 3
    rc = LINEIN(ThisFile);
 END;

 ThisLine = LINEIN(Thisfile);
 DO WHILE (ThisLine \= ' */')
    SAY SUBSTR(ThisLine, 7);
    ThisLine = LINEIN(Thisfile);
 END;

 rc = LINEOUT(Thisfile);

 RETURN('');

/* ------------------------------------------------------------------------- */
FileExist: PROCEDURE
 PARSE ARG FileName

 RETURN(STREAM(Filename, 'C', 'QUERY EXISTS') > '');

/* ========================================================================= */
unixslash: PROCEDURE
 PARSE ARG string
 RETURN(TRANSLATE( string, '/', '\'));

/* ========================================================================= */
dosslash: PROCEDURE
 PARSE ARG string
 RETURN(TRANSLATE( string, '\', '/'));


/* ========================================================================= */
CheckWriteInfo: PROCEDURE EXPOSE (GlobalVars)
PARSE ARG InfoFile, SearchDir, CvsUser, Wildcard;

 fWriteAllowed = FALSE;

 /* replace backslash by slash */
 SearchDir = unixslash( SearchDir);

rc = LINEOUT( 'C:\log', '---------');

 DO WHILE (TRUE)

    /* search write permission */
    rc = SysFileSearch( SearchDir, InfoFile, 'Line.');
    IF (rc \= 0) THEN
       LEAVE;

    DO i = 1 TO Line.0
       PARSE VAR Line.i InfoDir InfoUser;
       InfoUser = TRANSLATE( STRIP(InfoUser), ' ', ',');

       /* check this directory */
       IF (TRANSLATE(InfoDir) = TRANSLATE(SearchDir)) THEN
       DO
          IF ((Wildcard \= '') & (POS( Wildcard, InfoUser))) THEN
          DO
             fWriteAllowed = TRUE;
             LEAVE;
          END;

          IF (WORDPOS( TRANSLATE(CvsUser), TRANSLATE(InfoUser)) > 0) THEN
          DO
             fWriteAllowed = TRUE;
             LEAVE;
          END;
       END;
    END;

    /* is it already root dir ? then exit */
    IF (SearchDir = '/') THEN
       LEAVE;

    /* cut off one directory */
    SlashPos = LASTPOS( '/', SearchDir);
    IF (SlashPos = 1) THEN SlashPos = 2;
    SearchDir = LEFT( SearchDir, SlashPos - 1);

 END;

 RETURN(fWriteAllowed);

/* ========================================================================= */
CheckCommitAllowed: PROCEDURE EXPOSE (GlobalVars) CvsDirectory
 PARSE ARG CvsCheckTag CvsDirectory CvsFile;

 CvsDirectory     =  STRIP( CvsDirectory);
 CvsFile          =  STRIP( CvsFile);

 fWriteAllowed = FALSE;


 DO UNTIL (TRUE)

    /* directory to be written must reside below cvsroot */
    IF (POS( TRANSLATE( CvsRoot), TRANSLATE( CvsDirectory)) \= 1) THEN
       LEAVE;
    SearchDirectory = DELSTR( CvsDirectory, 1, LENGTH( CvsRoot));
    IF (SearchDirectory = '') THEN
       SearchDirectory = '/';

    fWriteAllowed = CheckWriteInfo( WriteInfoFile, SearchDirectory, CvsUser, '*');

 END;

 IF (\fWriteAllowed) THEN
 DO
    SAY 'cvs commit: pre-commit check for' unixslash(CvsDirectory);
    SAY 'cvs commit: access denied for user:' CvsUSer;
 END;
 RETURN( fWriteAllowed);

/* ========================================================================= */
CheckTagAllowed: PROCEDURE EXPOSE (GlobalVars) CvsDirectory CvsTagname CvsTagOperation
 PARSE ARG CvsCheckTag CvsTagName CvsTagOperation CvsDirectory CvsFileList;

 CvsTagName       =  STRIP( CvsTagName);
 CvsTagOperation  =  STRIP( CvsTagOperation);
 CvsDirectory     =  STRIP( CvsDirectory);
 CvsFileList      =  STRIP( CvsFileList);

 fWriteAllowed = FALSE;
 fCheckTag     = FALSE;

 DO UNTIL (TRUE)

    /* directory to be written must reside below cvsroot */
    IF (POS( TRANSLATE( CvsRoot), TRANSLATE( CvsDirectory)) \= 1) THEN
       LEAVE;
    SearchDirectory = DELSTR( CvsDirectory, 1, LENGTH( CvsRoot));
    IF (SearchDirectory = '') THEN
       SearchDirectory = '/';

    fWriteAllowed = CheckWriteInfo( WriteInfoFile, SearchDirectory, CvsUser, '*');
    IF (\fWriteAllowed) THEN
       LEAVE;

    /* has user access to CVSROOT ? Then do not check for personal tags */
    SearchDirectory = '/cvsroot';
    fCheckTag = \CheckWriteInfo( WriteInfoFile, SearchDirectory, CvsUser);

    /* allow only personal tags here */
    IF (fCheckTag) THEN
       fWriteAllowed = (POS( TRANSLATE(CvsUser)'_', TRANSLATE( CvsTagName)) = 1)

 END;

 IF (\fWriteAllowed) THEN
 DO
    SAY 'cvs tag: pre-tag check for' unixslash(CvsDirectory);
    IF (fCheckTag) THEN
    DO
       SAY 'cvs tag: personal tags allowed only for user:' CvsUser;
       SAY '         Preceed tag names with "'CvsUser'_" !';
    END;
    ELSE
       SAY 'cvs tag: access denied for user:' CvsUser;
 END;

 RETURN( fWriteAllowed);

