/*******************************************************/
/*                MIGRTMAN.CMD                         */
/*******************************************************/
/*                                                     */
/* COMPONENT_NAME:  DAE Common Install and             */
/*                  Configuration                      */
/*                                                     */
/* FUNCTIONS:                                          */
/*                                                     */
/* (C) COPYRIGHT International Business Machines       */
/* Corp. 1992                                          */
/* All Rights Reserved                                 */
/* Licensed Materials - Property of IBM                */
/*                                                     */
/* US Government Users Restricted Rights - Use,        */
/* duplication or disclosure restricted by GSA         */
/* ADP Schedule Contract with IBM Corp.                */
/*                                                     */
/* This command is used to manually migrate nodes which*/
/* were not up and running during the migration process*/
/*******************************************************/

Diskette = GetLoadDir()
NodeName     = ""
CIFDM = VALUE('CIFDM',,'OS2ENVIRONMENT')
IF CIFDM == ""
THEN DO
   SAY "Network Distributor does not appear to be installed. This"
   SAY "command is only executed on nodes to be manually migrated."
   SAY "Please see MIGRATE.DOC for details. "
   EXIT 99
END
'echo off'
'cls'
SAY "Now manually migrating this node...standby"
/* Diskette is where the rest of the files are , copy them on manually */
'copy 'Diskette'\cifdmapi.exe cifdmapx.exe'
'CIFDMAPX UPDATE BASE UPDATE INSTALL'
'del CIFDMAPX.EXE'
'CIFDMTRM'
'Call StartCIF'
exit
/******************************************************************************/
/*  GetLoadDir()                                                             |*/
/*                                                                            */
/*  Extract the name of the directory from which this module was              */
/*  loaded.                                                                   */
/******************************************************************************/
GetLoadDir: PROCEDURE

PARSE SOURCE "OS/2" "COMMAND" progname
loaddir = FILESPEC('drive', progname) || FILESPEC('path', progname)
loaddir = strip(loaddir)
loaddir = STRIP(loaddir, 'trailing', '\')

return loaddir

