/* REXX procedure to toggle Network drivers in config.sys      */
/* Rufan Redi Productions - (c) 1994 Version 1.0               */

/* Please backup your CONFIG.SYS before running this -
   just in case ! Also, have a boot disk handy !
   Please take note of the comment about the manual editing of
   your CONFIG.SYS before running this                         */

/* Comments to Jeremy E Cath CI$- 100315,521
   Donations to enable the work to continue via SnailMail to
    Stoke Cottage, Marsh Lane, Maidenhead, Berks SL6 0DF. UK   */

/* Requires VREXX.EXE, VREXX.DLL, DEVBASE.DLL
   to be present to display messages                           */
/* Requires GetBootDrv.DLL to locate boot drive                */
/* The program should be run ICONised                          */

/* In C:\CONFIG.SYS put the following two rem lines
               - CASE SENSITIVE !
rem ***NetworkStart
.
.  Network, or other drivers, device and run statements
.
rem ***NetworkEnd
   to control the blocks of lines which will be toggled.       */

'@echo off'

title = 'NetDrv 1.0 - a Rufan Redi Production'

call RxFuncAdd 'VInit', 'VREXX', 'VINIT'
initcode = VInit()
if initcode = 'ERROR' then signal CLEANUP

signal on failure name CLEANUP
signal on halt name CLEANUP
signal on syntax name CLEANUP

if arg(1) = 'YES' or arg(1) = 'NO' then
  whatsup = arg(1)
else
  DO
    msg.0 = 1
    msg.1 = 'Do you want the Network drivers to be activated ?'
    call VDialogPos 50,50
    whatsup = VMsgBox(title, msg, 6)
  END

if 0 < RxFuncQuery('SysLoadFuncs') THEN DO;
  Call rxfuncadd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs';
  Call SysLoadFuncs;
END;

Call rxfuncadd 'GetBootDrive','GBOOTDRV','GetBootDrive';
BootDrive=GetBootDrive();
Config = BootDrive':\config.sys'
TempFile = SysTempFileName('config.???')

Position.left = 20
Position.bottom = 50
Position.right = 80
Position.top = 60
Win = VOpenWindow(title, 'CYAN', position)
Call VSay Win, 70, 400, 'Please wait... Updating' config'.'

rc = lineout(TempFile,,1)

if whatsup = 'YES' then
  DO
    DO WHILE LINES(config) <> 0
      PARSE VALUE LINEIN(config) WITH first second rest
      if second = '*n*' then
        rc = lineout(TempFile, Space(rest))
      else
        rc = lineout(TempFile, Space(Space(first) Space(second) Space(rest)))
    end /* do */
    msg.1 = config 'now has the Network drivers active.'
  END
ELSE
  DO
    DO WHILE LINES(config) <> 0
      PARSE VALUE LINEIN(config) WITH first second rest
      rc = lineout(TempFile,Space(Space(first) Space(second) Space(rest)))
      if second = '***NetworkStart' then
      DO
        parse value LineIn(config) with first second rest
        do while second <> '***NetworkEnd'
          if second <> '*n*' then
            rc = lineout(TempFile,'rem *n*' Space(Space(first) Space(second) Space(rest)))
          else
            rc = lineout(TempFile,Space(Space(first) Space(second) Space(rest)))
          parse value LineIn(config) with first second rest
        end
        if second = '***NetworkEnd' then
          rc = lineout(TempFile,Space(Space(first) Space(second) Space(rest)))
      end
    end /* do */
    msg.1 = config 'now has the Network drivers commented out.'
  end
/* EndIf */
rc = stream(config,'c','close')
rc = stream(TempFile,'c','close')
copy TempFile config
rc = SysFileDelete(TempFile)

msg.0 = 3
msg.2 = ''
msg.3 = 'You will need to reboot your machine for these changes to be activated.'

call VCloseWindow Win
call VDialogPos 50, 50
rb = VMsgBox(title, msg, 1)

CLEANUP:
 call VExit
 Call RxFuncDrop 'GetBootDrive'

EXIT;
