/*******************************************************************************

This file defines:

   Default_FeelX
   Default_Shell
   Default_Actionbar

   Window


*******************************************************************************/

Default_FeelX:= menu [                   // RMB on title bar
            entry="Standard FeelX menu"  // not necessary in a toplevel menu
            item=feelx [ entry="FeelX"   // Selecting FeelX turns on/off
                         focus=false     // Sliding focus
                         all=false       // All controls off
                         cutpaste=true   // Cut & Paste in shells
(*                       hide=true       // hiding of mouse pointer *)
                       ] /* end feelx */
            item=altcutpaste             // alternate Cut & Paste keys
//          item=altcutpaste [entry="blah blah"] /* example other menu entry! */
            item=-                       // Separator
            item=Window                  // Window is a menu defined below
            item=-
            item=Prompt                  // Start a shell
            item=redraw                  // Redraw the contents of window
            item=top 
            item=winhotkey               // Assign a hotkey to this window
          ] /* end of menu */


Window := menu [                              // see feelx.inf for more information
            entry="window"
            item=*zorder[ entry="W. -> background", pos=wbottom]
            item= zorder[ entry="P.-> 1 back",      pos=pnext]
            item= zorder[ entry="P.-> background",  pos=pbottom]
            item= zorder[ entry="P.-> foreground",  pos=ptop]
          ] /* end of menu */

Default_Shell:= menu [                        //MMB on VDM
            entry="Standard Shell"
            item=keyin["C:\n","c:"]
            item=keyin["D:\n","d:"]
            item=keyin["E:\n","e:"]
            item=-
            item=keyin[entry="ESC\n",string="\e"]
            item=keyin[entry="Enter\n",string="\n"]
            item=keyin [entry="cd (%c)\n",string="cd %c\n" ]
            item=*keyin[ "dw\n", "~dw" ]
            item=keyin [ "scr\n", "~scr" ]
            item=keyin [ "zd\n", "~zd" ]
            item=keyin [entry="Delete Path (%C)\n",string="delpath %c\n"]
            item=-
            item=keyin [ entry="List (%c)\n",string="list %c\n"]
            item=keyin[ entry="~pk (%c)\n", string="pk %c\n" ]
            item=menu [
                        entry="~font"
                        item=*font [ entry="~small font", font=1 ]
                        item= font [ entry="~large font", font=5 ]
                      ] /* end of menu (anonymous item) */
            item=keyin [ entry="open folder", string="wpopen\n" ]
            item=kill [ entry="e~xit" /*, killchild=true */ ]
          ] /* end of main menu  (Standard_shell) */

Default_Desktop := menu [               //MMB on desktop
            item= hideactionbar
            item= Config Feelx
            item= Config WPS
            item= feelx [entry="Sliding Focus", focus=true]
            item= -
            item= CommandPrompts[]
            item=*Prompt                // Start a shell (* = this is default!)
            item= -
            item= Apps
            item= Games
            item= Tools
            item= StartUp
            item= -
            item= User_Documentation
            item= -
            item= HelpFeelX
            item=program [ entry="PM Shutdwn", name="e:\os2miss\pmshut.exe",
                 parameters="10",path="e:\os2miss"]
                 item=QuitFeelX [entry="Quit FeelX"]
          ] /* end of menu */

Focus off := program [title="Focus off",name="fxopt.exe",
                   parameters="focus:off",entry="Focus Off",window=invisible]

Default_Actionbar := actionbar [           // At top or bottom of desktop
            item=CommandPrompts[]
            item=Tools[]
            item=Apps[]
            item=Games[]
            item=ConfigActionbar
//          item=User_Documentation[]
            item=HelpFeelXActionbar
          ] /* end of menu */
//Startup := Default_Actionbar


Config Feelx:= menu [
            entry="Config Feelx"
            item=feelx [ entry="Cut & Paste", cutpaste=true ]
            item=feelx [ entry="Hide mouse", hide=true ]
            item=-
            item=hideactionbar
            item=-
            item=program [entry="Ed Toolbx",
            name="",parameters="teb.cmd",
            path="e:\feelx",type=os2win]
           ] /* end of menu */

ConfigActionbar:= menu [
            entry="Config"
            item=feelx [ entry="Sliding focus", focus=false ]
            item=feelx [ entry="Cut & Paste", cutpaste=true ]
            item=feelx [ entry="Hide mouse", hide=true ]
            item=-
            item=hideactionbar
            item=moveactionbar
            item=-
//          item=mwinlist[entry="Win List",all=false,items="startfx.exe"]
            item=program [ entry="Shutdwn", name="shutdown.exe",
            path=e:\os2miss,type=os2win]
            item=QuitFeelX
           ] /* end of menu */

Games:=menu [
          entry="Games"
          item=program [entry="MO",name="mo.exe",
          parameters="",VIDEO_8514A_XGA_IOTRAP=0,
          VIDEO_SWITCH_NOTIFICATION=1,path="d:\tarot",
          type=dosfs]
          item=program [entry="MineS",
          name="e:\os2games\mine.exe",path="e:\os2games"]
          item=program [entry="MahJ (non IBM)",
          name="e:\os2games\mahjongg.exe",path="e:\os2games"]
          ] /* end of menu */

Apps:=menu [
            entry="Apps"
            item=program [entry="FaxPM",
            name="e:\faxpm\faxpm.exe"]
            item=program [entry="FaxDDE",name="e:\faxpm\faxdde.exe"]
            item=program [entry="Zoc 2.0",
            name="e:\zoc\zoc.exe",parameters="",SESSION_PRIORITY=20,
            path="e:\zoc"]
            item=program [entry="MR212",
            name="e:\reader\mr2.exe",path="e:\reader",type=os2win]
            item= MODI
            item=program [entry="AmiPro 3.0b",
            name="e:\amipro\amipro.exe",path="e:\amipro"]
            ] /*end of menu */

MODI := chain [entry="123G v2.1",items=123G,items=Focus off]

123G:= program [entry="123G",
             name="e:\123g\123g.exe",parameters="",SESSION_PRIORITY=20,
             MOUSE_EXCLUSIVE_ACCESS=ON,path="e:\123g",child=false
             ]

Config WPS:=menu [
            entry="Config WPS"
            item=object [ entry="Sys Folder", object="<WP_CONFIG>" ]
            item=program [ entry="edit config.sys", name="tedit.exe", parameters="config.sys" ]
            item=program [ entry="Select Inst", name="install.exe" ]
            item=object [ entry="Font", object="<WP_FNTPAL>" ]
            item=object [ entry="System/ATI", object="<WP_SYSTEM>"]
           ] /* end of menu */



Prompt:= program [
            entry="Shell"
            type=os2win                  // no name: shell
            child=true                   // as a child: move to top
         ] /* end of program */


User_Documentation:= menu [
       entry="User Documentation"
  item= program [ entry="OS/2", name="view.exe", parameters="cmdref.inf" ]
  item= program [entry="4OS2",name="view.exe",parameters="e:\txtdoc\4os2.inf"]
           ] /* end of menu */

Tools:= menu [
      entry="Tools"
      item= pmkill
      item= minimize
      item= program [ entry="Mole", name="e:\os2miss\mole.exe",
      path="e:\os2miss"]
      item= program [ entry="PmShell",name="pmshell.exe",path="c:\os2",
      child=false]
      item= -
      item= program [ entry="Clipboard", name="clipos2.exe" ]
      item= program [ entry="Calculator", name="e:\os2miss\scalc.exe" ]
      item= program [ entry="Calandar",name="e:\os2miss\caldesk.exe"]
      item= -
      item=program[entry="PMCamera",name="e:\pmcam\pmcamera.exe",
      path="e:\pmcam"]
      item=program [entry="Ini Maint",name="e:\maint\inimaint.exe"
      ,path="e:\maint",window=pm]
      item=program[entry="PMJPEG",name="e:\peg\pmjpeg.exe",path="e:\peg"]
      item= Wo
      item= program [entry="Backmaster",name="e:\backmast\backmast.exe"]
      item= ReXX [ entry="ReXX: %c"
                   window=pm ]
      item= PmShell
      ] /* end of menu */

StartUp:= menu [
        entry="StartUp"
  item=program[entry="PMP 2.13",name="e:\pmp\pmpatrol.exe",
  path="e:\pmp",child=false]
  item=program[entry="Blanker",name="e:\blanker\blanker.exe",
  path="e:\blanker",child=false]
  item=program[entry="Watch Cat",name="watchcat.exe",path="e:\4os2",
  window=invisible,parameters="/1 /A",child=false,]
  item=program[entry="Watch Cat Toggle",name="watchcat.exe",path="e:\4os2",
  window=invisible,parameters="toggle"]
        ] /* end of menu */

Wo:= program [
       title="wo"                        // Title of pm window
       name="wo.exe"                     // The program name
       parameters="-p c-:[Which file?]"     // Ask for file as a parameter
       window=pm                         // -> send output to a PM-Window
       entry="Where is ...?"             // menu entry
       ]

cprogram:=program [ child=true ]

CommandPrompts:= menu [
      entry="Command Prompts"
      item=cprogram [ entry="OS/2 Shell (win)", type=os2win,
      parameters="alias /r e:\4os2\os2alist" ]
      item=cprogram [ entry="OS/2 Shell (fs)", type=os2fs,
      parameters="alias /r e:\4os2\os2alist" ]
      item=-
      item=cprogram [ entry="DOS Shell (win)", type=doswin,
      parameters="alias /r d:\4dos\dalist",VIDEO_8514A_XGA_IOTRAP=0,
      VIDEO_RETRACE_EMULATION=ON
      ]
      item=cprogram [ entry="DOS Shell (fs)", type=dosfs,
      parameters="alias /r d:\4dos\dalist",VIDEO_8514A_XGA_IOTRAP=0,
      VIDEO_RETRACE_EMULATION=ON
      ]
      item=-

      item=cprogram [ entry="Windows (fs)", name="progman.exe",
      parameters="",VIDEO_8514A_XGA_IOTRAP=0,
      VIDEO_RETRACE_EMULATION=1,DPMI_MEMORY_LIMIT =64,
      VIDEO_SWITCH_NOTIFICATION=1,SESSION_PRIORITY=10,
      window=maximized,
      type=windoze31 ]
      item=cprogram [entry="QBW-Painting",
      name="d:\qbooksw\qbw.exe ",
      parameters="d:\accdata\accent_p.qbw",VIDEO_8514A_XGA_IOTRAP=0,
      VIDEO_RETRACE_EMULATION=1,DPMI_MEMORY_LIMIT =64,
      VIDEO_SWITCH_NOTIFICATION=1,
      window=maximized,
      type=windoze31seamless]
      item=cprogram [entry="QBW-Personal",
      naem="d:\qbooksw\qbw.exe",
      parameters="d:\accbryan\accent_p.qbw",VIDEO_8514A_XGA_IOTRAP=0,
      VIDEO_RETRACE_EMALATION=1,DPMI_MEMORY_LIMIT =64,
      VIDEO_SWITCH_NOTIFICATION=1,
      window=maximized,
      type=windoze31seamless ]
      item=cprogram [ entry="Windows (seamless)", name="progman.exe",
      parameters="",VIDEO_8514A_XGA_IOTRAP=0,
      VIDEO_RETRACE_EMULATION=1,DPMI_MEMORY_LIMIT =64,
      VIDEO_SWITCH_NOTIFICATION=1,
      window=maximized,
      type=windoze31seamless ]
                    ] /* end of menu */

HelpFeelX:= menu [
      entry="Help"
      item=*program [ entry="FeelX Doc", name="view.exe", parameters="e:\feelx\feelx.inf"]
      item=program [ feelxpath=true, entry="FeelX Help about %c", name="view.exe", parameters="feelx &" ]
      item=program [ entry="OS/2 Help about %c", name="view.exe", parameters="cmdref &" ]
      ]

HelpFeelXActionbar:= menu [
      entry="Help"
      item=program [ entry="FeelX Doc", name="view.exe", parameters="feelx" ]
      item=program [ entry="Help about %c", name="view.exe", parameters="feelx &" ]
      item=program [ entry="OS/2 Help about %c", name="view.exe",
       parameters="cmdref &" ]
      ]
OS2Help:=program [entry="OS/2 Cmd~Help", name="view.exe", parameters="cmdref &"]

ReXX := program [
                  feelxpath=true
                  name="callrx.exe"
                  entry="ReXX"
                  rexxfile="interp.cmd"
                  rexxparameter="&"
                  parameters="<rexxfile> <rexxparameter>"
                ]

Default_Hotkeys:=hotkey [
// Please note: only the first two entry are on per default,
// all others are commented out.
// Ctrl-Shift-PgDn: Move window into the Background
                pgdn=zorder [ pos=pbottom ]
// Ctrl-Shift-PgUp: Move window into the Front
                pgup=zorder [ pos=ptop ]
                        ]
