/* REXX */
parse arg parms
parse var parms parms '/'option rest
debug = FALSE
start_disk = 1
image_dir = ''
rest = translate(rest)
option = translate(option)
do while (option > "")
  select
    when (left(option,1) = 'S') then
       do
         start_disk = substr(option,2)
         if datatype(start_disk) <> 'NUM' then call Usage("Invalid /S option")
       end
    when (left(option,1) = 'I') then
       do
         image_dir = substr(option,2)
         if right(image_dir,1) = '\' then image_dir = left(image_dir,length(image_dir) - 1)
       end
    when (left(option,1) = 'T') then
       do
         debug = TRUE
       end
    otherwise;
       call Usage "Invalid option:" option
  end
  parse var rest '/'option rest
end
if image_dir > '' then
do
  currdir = directory()
  newdir = directory(image_dir)
  call directory currdir
  if newdir <> image_dir then
  do
    call rxfuncadd 'sysmkdir','rexxutil','sysmkdir'
    rc = SysMkDir(image_dir)
    if rc <> 0 then call Usage("Could not create directory "image_dir)
  end
  image_dir = image_dir || '\DISK'
end
parms = parms ' ' rest
if words(parms) > 2  then call Usage
image_name = word(parms,1)
num_images = word(parms,2)
if image_name = '?' then call Usage
if num_images > '' & datatype(num_images) <> 'NUM' then call Usage
if pos('?',image_name) = 0 then call Usage("Image file name must contain a '?'")
parse var image_name begin_name'?'end_name
if num_images = '' then
do
  do num_images = start_disk by 1
    if stream(begin_name || num_images || end_name,'Command','Query Exists') = ''
    then leave
  end
  num_images = num_images - start_disk
end
last_disk = start_disk + num_images - 1
do n = start_disk to last_disk
  fname = begin_name || n || end_name
  if stream(fname,'Command','Query Exists') = ''
  then do
          call Usage("File, "fname", does not exists!")
       end
end
say 'Will copy 'begin_name || start_disk || end_name' thru 'begin_name || last_disk || end_name
do n = start_disk to last_disk
 if image_dir = '' then do
   say ''
   say 'Insert diskette #'n', hit any key to continue...'
   pull
 end
 else say 'Creating diskette image #'n
 command = 'loaddskf 'begin_name || n || end_name ' a: /F /Y'
 if debug = TRUE then say command
                 else command
 if image_dir > '' then
 do
   if n < 10 then dirnum = '0'n
             else dirnum = n
   target_dir = image_dir || dirnum
   say 'Creating directory 'target_dir
   if debug = FALSE
   then call SysMkDir target_dir
   command = 'xcopy a:*.* 'target_dir '/S'
   if debug = TRUE then say command
                   else command
 end
end
return

Usage:procedure
parse arg message

  say '**********************************************************************'
  say ' 'd2c(7)
  if message > "" then do
    say message
    say ""
  end
  say "Usage: makeimg imagefile_name | number_of_images | | options |"
  say 'Where: imagefile_name is in the format name_part_1 + ? |+ name_part_2 |'
  say "       The '?' denotes the position in the file name that contains an "
  say "       incrementing value"
  say "       "
  say "       If number_of_images is not specified then the program will use all"
  say "       valid matches for the file name."
  say "Options:"
  say "        /Sn = Start Disk "
  say "        /Ip = Create images at root path p (e.g. /Ic:\img)"
  say "        /T  = Run in test mode. Do not copy any files. Report only."
  say ""
  say "Example: makeimg us8049_?.img 7"
  say "         will create 7 images starting with us8049_1.img -> us8049_7.img"
  exit

