/* REXX */
call rxfuncadd 'sysfiletree','rexxutil','sysfiletree'
call rxfuncadd 'sysfiledelete','rexxutil','sysfiledelete'
call sysfiletree '*.PKG','pkgfile.'

TRUE = 1
FALSE= 0

do n = 1 to pkgfile.0
  pkgfile.n = word(pkgfile.n,5)
  recnum = 0
  change_pending = FALSE
  say 'Reading 'pkgfile.n
  do while (lines(pkgfile.n) > 0)
    rec = linein(pkgfile.n)
    recnum = recnum + 1
    pkgrec.recnum = rec
    pkgrec.0 = recnum
    if substr(rec,1,7) = 'SOURCE=' then
    do
      srcline = recnum
      change_pending = TRUE
    end
    if substr(rec,1,7) = 'VOLUME=' then
    do
      if change_pending = TRUE then
      do
         volnum = substr(rec,14)
         if datatype(volnum) = 'NUM' then
         do
            if volnum < 10 then volnum = '0'volnum
            pkgrec.srcline = left(pkgrec.srcline,15) || '../DISK'volnum'/' || ,
                             substr(pkgrec.srcline,16)
         end
      end
      change_pending = FALSE
    end
  end
  call stream pkgfile.n, 'COMMAND', 'CLOSE'
  rc = SysFileDelete(pkgfile.n)
  if rc <> 0 then
  do
    say 'Could not delete file: 'pkgfile.n', Code = 'rc
    exit
  end
  say 'Rewriting' pkgfile.n
  do y = 1 to pkgrec.0
    call lineout pkgfile.n, pkgrec.y
  end
  call stream pkgfile.n, 'COMMAND', 'CLOSE'
end
say 'Done !'
