/* 
 * Mach Operating System
 * Copyright (c) 1991,1990,1989,1988,1987 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS 
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie the
 * rights to redistribute these changes.
 */
/*
 * HISTORY
 * $Log:	vm_init.c,v $
 * Revision 2.4  91/02/05  17:58:17  mrt
 * 	Changed to new Mach copyright
 * 	[91/02/01  16:32:11  mrt]
 * 
 * Revision 2.3  90/02/22  20:05:35  dbg
 * 	Reduce lint.
 * 	[90/01/29            dbg]
 * 
 * Revision 2.2  89/09/08  11:28:15  dbg
 * 	Initialize kalloc package here.
 * 	[89/09/06            dbg]
 * 
 * 	Removed non-XP code.
 * 	[89/04/28            dbg]
 * 
 * Revision 2.10  89/04/22  15:35:20  gm0w
 * 	Removed MACH_VFS code.
 * 	[89/04/14            gm0w]
 * 
 * Revision 2.9  89/04/18  21:25:30  mwyoung
 * 	Recent history:
 * 	 	Add memory_manager_default_init(), vm_page_module_init().
 * 
 * 	Older history has been integrated into the documentation for
 * 	this module.
 * 	[89/04/18            mwyoung]
 * 
 */
/*
 *	File:	vm/vm_init.c
 *	Author:	Avadis Tevanian, Jr., Michael Wayne Young
 *	Date:	1985
 *
 *	Initialize the Virtual Memory subsystem.
 */

#include <mach/machine/vm_types.h>
#include <kern/lock.h>
#include <vm/vm_object.h>
#include <vm/vm_map.h>
#include <vm/vm_page.h>
#include <vm/vm_kern.h>

extern void	memory_manager_default_init();
extern void	kalloc_init();

/*
 *	vm_init initializes the virtual memory system.
 *	This is done only by the first cpu up.
 *
 *	The start and end address of physical memory is passed in.
 */

void vm_mem_init()
{
	extern vm_offset_t	avail_start, avail_end;
	extern vm_offset_t	virtual_avail, virtual_end;

	/*
	 *	Initializes resident memory structures.
	 *	From here on, all physical memory is accounted for,
	 *	and we use only virtual addresses.
	 */

	virtual_avail = vm_page_startup(avail_start, avail_end, virtual_avail);

	/*
	 *	Initialize other VM packages
	 */

	zone_bootstrap();
	vm_object_init();
	vm_map_init();
	kmem_init(virtual_avail, virtual_end);
	pmap_init(avail_start, avail_end);
	zone_init();
	kalloc_init();
	vm_page_module_init();
	memory_manager_default_init();
	
}
