.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	vm_region.man,v $
.\" Revision 2.2  90/08/07  18:48:05  rpd
.\" 	Created.
.\" 
.TH vm_region 2 11/20/87
.CM 4
.SH NAME
.nf
vm_region  \-  returns information about regions of a task's address space
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t  vm_region(target_task, address, size, protection,
			 max_protection, inheritance, shared,
			 object_name, offset)
	vm_task_t		target_task;
        vm_address_t		*address;		/* in/out */
        vm_size_t		*size;			/* out */
	vm_prot_t		*protection;		/* out */
	vm_prot_t		*max_protection;	/* out */
	vm_inherit_t		*inheritance;		/* out */
	boolean_t		*shared;		/* out */
	port_t			*object_name;		/* out */
	vm_offset_t		*offset;		/* out */


.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
target_task
The task for which an address space description is requested.
.TP 15
.B
address
The address at which to start looking for a region.
.TP 15
.B
size
The size (in bytes) of the located region.
.TP 15
.B
protection
The current protection of the region.
.TP 15
.B
max_protection
The maximum allowable protection for this region.
.TP 15
.B
inheritance
The inheritance attribute for this region.
.TP 15
.B
shared
Is this region shared or not.
.TP 15
.B
object_name
The port identifying the memory object associated with this
region.  (See 
.B pager_init
.) 
.TP 15
.B
offset
The offset into the pager object that this region begins at.

.SH DESCRIPTION

.B vm_region
returns a description of the specified region of the target
task's virtual address space.  
.B vm_region
begins at 
.B address
and looks
forward thru memory until it comes to an allocated region.  (If address is
within a region, then that region is used.)  Various bits of information
about the region are returned.  If 
.B address
was 
.B not
within a region,
then 
.B address
is set to the start of the first region which follows the
incoming value.  In this way an entire address space can be scanned.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
Region located and information returned.
.TP 25
KERN_NO_SPACE
There is no region at or above 
.B address
in the specified task.

.SH SEE ALSO
.B vm_allocate, vm_deallocate, vm_protect, vm_inherit





