.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	vm_read.man,v $
.\" Revision 2.2  90/08/07  18:47:57  rpd
.\" 	Created.
.\" 
.TH vm_read 2 1/13/87
.CM 4
.SH NAME
.nf
vm_read  \-  allows one task to read another's memory
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t vm_read(target_task, address, size, data, data_count)
	vm_task_t	target_task
	vm_address_t	address;
	vm_size_t	size;
	pointer_t	*data;		/* out */
	int		*data_count;	/* out */


.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
target_task
Task whose memory is to be read.
.TP 15
.B
address
The first address to be read (must be
on a page boundary).
.TP 15
.B
size
The number of bytes of data to be read
(must be an integral number of pages)
.TP 15
.B
data
The array of data copied from the given task.
.TP 15
.B
data_count
The size of the 
.B data
array in bytes.
(will be an integral number of pages).

.SH DESCRIPTION
.B vm_read
allows one task's virtual memory to be read by
another task. Note that the data array is returned in a
newly allocated region; the task reading the data should
.B vm_deallocate
this region when it is done with the data.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
Memory read.
.TP 25
KERN_INVALID_ARGUMENT
Either the address does not start on a page
boundary or the size is not an integral number of pages.
.TP 25
KERN_NO_SPACE
There is not enough room in the callers
virtual memory to allocate space for the data to be returned.
.TP 25
KERN_PROTECTION_FAILURE
The address region in the target task is 
protected against reading.
.TP 25
KERN_INVALID_ADDRESS
Illegal or non-allocated address specified, or there 
was not 
.B size
bytes of data following that address.

.SH SEE ALSO
.B vm_read, vm_write, vm_copy, vm_deallocate

