.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	vm_deallocate.man,v $
.\" Revision 2.2  90/08/07  18:47:22  rpd
.\" 	Created.
.\" 
.TH vm_deallocate 2 9/19/86
.CM 4
.SH NAME
.nf
vm_deallocate  \-  releases a region of a task's address space
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t vm_deallocate(target_task, address, size)
	vm_task_t	target_task;
	vm_address_t    address;
	vm_size_t	size;


.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
target_task
Task whose virtual memory is to be affected.
.TP 15
.B
address
Starting address (will be rounded down to a page boundary).
.TP 15
.B
size
Number of bytes to deallocate (will be rounded up to give a 
page boundary).

.SH DESCRIPTION
.B vm_deallocate
relinquishes access to a region of a task's
address space, causing further access to that memory to fail.
This address range will be available for reallocation.
Note, that because of the rounding to virtual page boundaries, more
than 
.B size
bytes may be deallocated. Use 
.B vm_page_size
or
.B vm_statistics
to
find out the current virtual page size.

This call may be used to deallocte memory that was passed to a task
in a message (via out of line data). In that case, the rounding should
cause no trouble, since the region of memory was allocated as a set
of pages.

The 
.B vm_deallocate
call affects only the task specified by the 
.B target_task
.
Other tasks which may have access to this memory may continue to reference it.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
Memory deallocated.
.TP 25
KERN_INVALID_ADDRESS
Illegal or non-allocated address specified.

.SH SEE ALSO
.B vm_allocate, vm_statistics, msg_receive

