.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	thread_state.man,v $
.\" Revision 2.2  90/08/07  18:46:38  rpd
.\" 	Created.
.\" 
.TH thread_state 2 1/20/88
.CM 4
.SH NAME
.nf
thread_get_state  \-  return  machine dependent state
thread_set_state  \-  set  machine dependent state
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t thread_get_state(target_thread, flavor, old_state,
				old_stateCnt)
	thread_t 		target_thread;
	int 			flavor;
	thread_state_data_t 	old_state;	/* in and out */
	unsigned int 		*old_stateCnt;  /* in and out */


.fi
.ft P
.nf
.ft B
kern_return_t thread_set_state(target_thread, flavor, new_state,
				new_stateCnt)
	thread_t 		target_thread;
	int 			flavor;
	thread_state_data_t 	new_state;
	unsigned int 		new_stateCnt;


.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
target_thread
thread to get or set the state for.
.TP 15
.B
flavor
The type of state that is to be manipulated. Currently must
be one of the following values: 
.B VAX_THREAD_STATE
, 
.B ROMP_THREAD_STATE
,

.B SUN_THREAD_STATE_REGS
, 
.B SUN_THREAD_STATE_FPA
.TP 15
.B
new_state
an array of state information
.TP 15
.B
old_state
an array of state information
.TP 15
.B
new_stateCnt
the size of the state information array. Currently must
be one of the following values: 
.B VAX_THREAD_STATE_COUNT
,
.B ROMP_THREAD_STATE_COUNT
, 
.B SUN_THREAD_STATE_REGS_COUNT
,
.B SUN_THREAD_STATE_FPA_COUNT
.TP 15
.B
old_stateCnt
same as 
.B new_stateCnt

.SH DESCRIPTION

.B thread_get_state
returns the state component (e.g. the machine registers)
of 
.B target_thread
as specified by 
.B flavor
.
The 
.B old_state
is an array of integers that is provided by the
caller and returned filled with the specified information. 
.B old_stateCnt

is input set to the maximum number of integers in 
.B old_state
and
returned equal to the actual 
number of integers in 
.B old_state
.

.B thread_set_state
sets the state component (e.g. the machine registers)
of 
.B target_thread
as specified by 
.B flavor
.
The 
.B new_state
is an array of integers. 
.B new_stateCnt
is the 
number of elements in 
.B new_state
. The entire set of registers
is reset. This will do unpredictable things if 
.B target_thread
is not suspended.

.B target_thread
may not be 
.B thread_self
for either of
these calls.

The definition of the state structures can be found in
<machine/thread_status.h>

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The state has been set or returned
.TP 25
MIG_ARRAY_TOO_LARGE
Returned state is too large for the
.B new_state
array. 
.B new_state
is filled in as much
as possible and 
.B new_stateCnt
is set to the 
number of elements that would be returned if there were
enough room.
.TP 25
KERN_INVALID_ARGUMENT
.B target_thread
is not a thread or
is 
.B thread_self
or 
.B flavor
is unrecogized for this machine.

.SH SEE ALSO
.B task_info, thread_info


