.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	thread_resume.man,v $
.\" Revision 2.2  90/08/07  18:46:22  rpd
.\" 	Created.
.\" 
.TH thread_resume 2 1/22/88
.CM 4
.SH NAME
.nf
thread_resume  \-  resumes specified thread
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t thread_resume(target_thread)
	thread_t	target_thread;


.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
target_thread
The thread to be resumed.

.SH DESCRIPTION
Decrements the threads's suspend count. If the count becomes zero
the thread is resumed. If it is still positive, the thread
is left suspended. The suspend count may not become negative.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The thread has been resumed.
.TP 25
KERN_FAILURE
The suspend count is already zero.
.TP 25
KERN_INVALID_ARGUMENT
.B target_thread
is not a thread.

.SH SEE ALSO
.B task_suspend, task_resume
.B thread_info, thread_create, thread_terminate, thread_suspend



