.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	thread_info.man,v $
.\" Revision 2.2  90/08/07  18:45:59  rpd
.\" 	Created.
.\" 
.TH thread_info 2 1/20/88
.CM 4
.SH NAME
.nf
thread_info  \-  gets thread machine independent information
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

/* the definition of thread_info_data_t from mach.h - mach/thread_info.h is */

   typedef	int	*thread_info_t;	/* variable length array of int */

/* only current interpretation of thread_info */

   struct thread_basic_info {
	time_value_t	user_time;	/* user run time */
	time_value_t	system_time;	/* system run time */
	int		cpu_usage;	/* scaled cpu usage percentage */
	int		base_priority;	/* base scheduling priority */
	int		cur_priority;	/* current scheduling priority */
	int		run_state;	/* run state (see below) */
	int		flags;		/* various flags (see below) */
	int		suspend_count;	/* suspend count for thread */
	long		sleep_time;	/* number of seconds that thread
					   has been sleeping */
   };
   typedef struct thread_basic_info	*thread_basic_info_t;

   The possible values of the run_state field are:
	TH_STATE_RUNNING, thread is running normally 
	TH_STATE_STOPPED, thread is suspended
 	TH_STATE_WAITING, thread is waiting normally 
	TH_STATE_UNINTERRUPTIBLE, thread is in an uninterruptible wait
	TH_STATE_HALTED, thread is halted at a clean point 

   The possible values of the flags field are:
	TH_FLAGS_SWAPPED, thread is swapped out 
	TH_FLAGS_IDLE, thread is an idle thread 


.nf
.ft B
kern_return_t thread_info(target_thread, flavor, thread_info, 
				thread_infoCnt)
	thread_t 		target_thread;
	int 			flavor;
	thread_info_t 		thread_info;	/* in and out */
	unsigned int 		*thread_infoCnt;  /* in and out */


.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
target_thread
The thread to be affected.
.TP 15
.B
flavor
The type of statistics that are wanted.  Currently only
.B THREAD_BASIC_INFO
is implemented.
.TP 15
.B
thread_info
Statistics about the thread specified by 
.B target_thread
.
.TP 15
.B
thread_infoCnt
Size of the info structure. Currently only 
.B THREAD_BASIC_INFO_COUNT
is  implemented.

.SH DESCRIPTION

Returns the selected information array for a thread, as specified
by 
.B flavor
. 
.B thread_info
is an array of integers that is supplied
by the caller and returned filled with specified information. 
.B thread_infoCnt
is supplied as the maximum number of integers in 
.B thread_info
. On return,
it contains the actual number of integers in 
.B thread_info
.

Currently there is only one flavor of information which is defined
by 
.B THREAD_BASIC_INFO
. Its size is defined by 
.B THREAD_BASIC_INFO_COUNT
.


.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The call succeeded.
.TP 25
KERN_INVALID_ARGUMENT
.B target_thread
is not a thread or
.B flavor
is not recognized.
.TP 25
MIG_ARRAY_TOO_LARGE
Returned info array is too large for
.B thread_info
. 
.B thread_info
is filled as much as possible.
.B thread_infoCnt
is set to the number of elements that would
have been returned if there were enough room.

.SH SEE ALSO
.B thread_special_ports, task_threads,
.B task_info, thread_state




