.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	task_create.man,v $
.\" Revision 2.2  90/08/07  18:43:31  rpd
.\" 	Created.
.\" 
.TH task_create 2 1/22/88
.CM 4
.SH NAME
.nf
task_create  \-  creates new task from a parent task
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t task_create(parent_task, inherit_memory,
				 child_task)
	task_t		parent_task	
	boolean_t	inherit_memory;
	task_t		*child_task;	/* out */


.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
target_task
The task from which the child's capabilities are drawn.
.TP 15
.B
inherit_memory
If set, the child task's address space is built 
from the parent task according to its memory inheritance values;
otherwise, the child task is given an empty address space.
.TP 15
.B
child_task
The new task.

.SH DESCRIPTION
.B task_create
creates a new task from 
.B parent_task
; the
resulting task (
.B child_task
)
acquires shared or copied parts of the parent's address space (see
.B vm_inherit
).
The child task initially contains no threads.

The child task gets the four special ports created or copied for
it at task creation. The 
.B task_kernel_port
is created and
send rights for it are given to the child and 
returned to the caller. The 
.B task_notify_port
is created and receive, ownership and send rights for it are given to the
child. The caller has no access to it.  The 
.B task_bootstrap_port
and the 
.B task_exception_port
are inherited from the parent task.
The new task can get send rights to these ports with the call 
.B task_get_special_port
.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
A new task has been created.
.TP 25
KERN_INVALID_ARGUMENT
.B parent_task
is  not a valid task port.
.TP 25
KERN_RESOURCE_SHORTAGE
Some critical kernel resource is unavailable.

.SH SEE ALSO
.B task_terminate, task_suspend, task_resume, task_special_ports,
.B task_threads, thread_create, thread_resume,
.B vm_inherit

.SH BUGS
Not implemented yet. Use 
.B fork
.

