.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	task_assign.man,v $
.\" Revision 2.2  90/08/07  18:43:23  rpd
.\" 	Created.
.\" 
.TH task_assign 2 8/13/89
.CM 4
.SH NAME
.nf
task_assign  \-  assign task to processor set
task_assign_default  \-  assign task to default processor set
task_get_assignment  \-  get processor set to which task is assigned
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t
task_assign(task, processor_set, assign_threads)
	task_t task;
	processor_set_t processor_set;
	boolean_t	assign_threads;


.fi
.ft P
.nf
.ft B
kern_return_t
task_assign_default(task, assign_threads)
	task_t		task;
	boolean_t	assign_threads;


.fi
.ft P
.nf
.ft B
kern_return_t
task_get_assignment(task, processor_set)
	task_t		task;
	processor_set_name_t	*processor_set;


.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
task
The task to be affected.
.TP 15
.B
processor_set
The processor set to assign it to, or the processor 
set to which it is assigned.
.TP 15
.B
assign_threads
Boolean indicating whether this assignment applies 
to existing threads in the task.

.SH DESCRIPTION
.B task_assign
assigns 
.B task
the the set 
.B processor_set.
This assignment is for the purposes of determining the initial assignment
of newly created threads in 
.B task.
Any previous assignment of
the task is nullified.  Existing threads within the task are also reassigned
if 
.B assign_threads
is TRUE.  They are not affected if it is FALSE.

.B task_assign_default
is a variant of 
.B task_assign
that assigns the task to the default processor set on that task's host.
This variant exists
because the control port for the default processor set is privileged and
not ususally available to users.


.B task_get_assignment
returns the current assignment of the task.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The assignment has been performed.
.TP 25
KERN_INVALID_ARGUMENT
.B task
is not a task, or
.B processor_set
is not a processor_set on the same host as
.B task
.

.SH BUGS
Availability limited

.SH SEE ALSO
.B processor_set_create, processor_set_info, processor_assign, thread_assign
,
.B host_processor_set_priv

