.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	processor_set_tasks.man,v $
.\" Revision 2.2  90/08/07  18:43:03  rpd
.\" 	Created.
.\" 
.TH processor_set_tasks 2 8/13/89
.CM 4
.SH NAME
.nf
processor_set_tasks /- gets task ports for tasks assigned to a processor set \-
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t processor_set_tasks(processor_set, task_list, task_count)
	processor_set_t	processor_set;
	task_array_t	*task_list;	/* out, ptr to array */
	int		*task_count;	/* out */


.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
processor_set
The processor_set to be affected.
.TP 15
.B
task_list
The set of tasks currently assigned to 
.B processor_set
;
no particular ordering is guaranteed. 
.TP 15
.B
task_count
The number of tasks in the 
.B task_list.

.SH DESCRIPTION
.B processor_set_tasks
gets send rights to  the  kernel port for each task
currently assigned to 
.B processor_set.

.B task_list
is an array that is
created as a result of this call. The caller may wish to 
.B vm_deallocate
this array when the data is no longer needed.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The call succeeded.
.TP 25
KERN_INVALID_ARGUMENT
.B processor_set
is not a processor_set.

.SH BUGS
Availability limited.

.SH SEE ALSO
.B task_assign, thread_assign, processor_set_threads



