.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	processor_set_policy_enable.man,v $
.\" Revision 2.2  90/08/07  18:42:56  rpd
.\" 	Created.
.\" 
.TH processor_set_policy_enable 2 8/13/89
.CM 4
.SH NAME
.nf
processor_set_policy_enable  \-  enable scheduling policy on processor set
processor_set_policy_disable  \-  disable scheduling policy on processor set
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t
processor_set_policy_enable(processor_set, policy)
	processor_set_t processor_set;
	int		policy;


.fi
.ft P
.nf
.ft B
kern_return_t
processor_set_policy_disable(processor_set, policy, change_threads)
	thread_t	thread;
	processor_set_t	processor_set;
	int		change_threads;




.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
processor_set
The processor set whose allowed policies are to be changed.
.TP 15
.B
policy
The policy to enable or disable
.TP 15
.B
change_threads
Reset the policies of any threads with the newly-disallowed policy to
timesharing.

.SH DESCRIPTION
Processor sets may restrict the scheduling policies to be used for
threads assigned to them.  These two calls provide the mechanism for
designating permitted and forbidden policies.  The current set of
permitted policies can be obtained from 
.B processor_set_info.
Timesharing may not
be forbidden by any processor_set.  This is a compromise to reduce the
complexity of the assign operation; any thread whose policy is forbidden by
the target processor set has its policy reset to timesharing.  If the
.B change_threads
argument to 
.B processor_set_policy_disable
is true, threads currently assigned to this processor set and using the
newly disabled policy will have their policy reset to timesharing.

<mach/policy.h> contains the allowed policies; it is included by mach.h.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
Operation completed successfully
.TP 25
KERN_INVALID_ARGUMENT
.B processor_set
is not a processor set,
or 
.B policy
is not a valid policy, or an attempt was made to disable timesharing.

.SH BUGS
Availability limited.  Not all policies (e.g. fixed priority) are supported
by all systems.

.SH SEE ALSO
.B thread_policy, task_policy

