.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	processor_set_max_priority.man,v $
.\" Revision 2.2  90/08/07  18:42:50  rpd
.\" 	Created.
.\" 
.TH processor_set_max_priority 2 8/13/89
.CM 4
.SH NAME
.nf
processor_set_max_priority  \-  set maximum priority for a processor_set
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t
processor_set_max_priority(processor_set, priority, change_threads)
	processor_set_t		task;
	int			priority;
	boolean_t		change_threads;


.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
processor_set
Processor set to set maximum priority for.
.TP 15
.B
priority
New priority.
.TP 15
.B
change_threads
Change maximum priority of existing threads if TRUE.

.SH DESCRIPTION
The priority of a processor set is used only for newly created threads
(thread's maximum priority is set to processor set's) and the assignment
of threads to the set (thread's maximum priority is reduced if it exceeds
the set's maximum priority, thread's priority is similarly reduced).
.B processor_set_max_priority
changes this priority.  It also sets the maximum priority of
all threads assigned to the processor set 
to this new priority if 
.B change_threads
is TRUE.  If this maximum priority is less than the priorities of any
of these threads, their priorities will also be set to this new value.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The call succeeded.
.TP 25
KERN_INVALID_ARGUMENT
.B task
is not a task, or
.B priority
is not a valid priority.

.SH BUGS
Availability limited.  This call was referred to as 
.B processor_set_priority
in some previous documentation.

.SH SEE ALSO
.B thread_priority, task_priority, thread_assign




