.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	memory_object_server.man,v $
.\" Revision 2.2  90/08/07  18:41:32  rpd
.\" 	Created.
.\" 
.TH memory_object_server 2 12/19/89
.CM 4
.SH NAME
.nf
memory_object_server  \-  main program of memory manager
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
boolean_t memory_object_server(in_msg, out_msg)
	msg_header_t	*in_msg;	
	msg_header_t	*out_msg;


.fi
.ft P
.SH DESCRIPTION
A 
.B memory manager
is a server task that responds to specific
messages from the kernel in order to handle memory management functions for
the kernel.

In order to isolate the memory manager from the specifics of message
formatting, the remote procedure call generator produces a
procedure, 
.B memory_object_server
, to handle a received message.
This function does all necessary argument handling, and actually
calls one of the following  functions: 
.B memory_object_init
,
.B memory_object_data_write, memory_object_data_request,
.B memory_object_data_unlock, memory_object_lock_completed,
.B memory_object_copy, memory_object_terminate
. A 
.B default memory manager
may get two additional requests from the kernel: 
.B memory_object_create
and 
.B memory_object_data_initialize
.  

The return value from the 
.B memory_object_server
function indicates that
the message was appropriate to the memory management interface
(returning 
.B TRUE
), or that it could not handle this message
(returning 
.B FALSE
).

.SH ARGUMENTS
.TP 15
.B
.B in_msg
The message that has been received from the kernel.
.TP 15
.B
.B out_msg
A reply message. Not used for this server

.SH DIAGNOSTICS
.TP 25
.B TRUE
From 
.B memory_object_server
, indicates that the message
in question was applicable to this interface, and that the appropriate
routine was called to interpret the message.
.TP 25
.B FALSE
From 
.B memory_object_server
, indicates that the message
did not apply to this interface, and that no other action was taken.

.SH SEE ALSO
.B memory_object_init,memory_object_data_request,memory_object_data_unlock,
.B memory_object_data_write,memory_object_copy,memory_object_terminate,
.B memory_object_lock_completed, memory_object_data_initialize,
.B memory_object_create

