.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	memory_object_lock_request.man,v $
.\" Revision 2.2  90/08/07  18:41:26  rpd
.\" 	Created.
.\" 
.TH memory_object_lock_request 2 12/19/89
.CM 4
.SH NAME
.nf
memory_object_lock_request  \-  request consistency control actions
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t	memory_object_lock_request(memory_control,
				offset, size, should_clean
				should_flush, lock_value, reply_to)
	memory_object_control_t
			memory_control;
	vm_offset_t	offset;
	vm_size_t	size;
	boolean_t	should_clean;
	boolean_t	should_flush;
	vm_prot_t	lock_value;
	port_t		reply_to;


.fi
.ft P
.SH DESCRIPTION

.B memory_object_lock_request
allows a memory manager to make cache
management requests.
As specified in arguments to the call, the kernel will:
clean (i.e., write back using 
.B memory_object_data_write
)
any cached data which
has been modified since the last time it was written;
flush (i.e., remove any uses of) that data from memory;
lock (i.e., prohibit the specified uses of) the cached data.
Locks applied to cached data are not cumulative; new lock values override
previous ones.  Thus, data may also be unlocked using this primitive.
The lock values must be one or more of the following values:
.B VM_PROT_NONE, VM_PROT_READ, VM_PROT_WRITE, VM_PROT_EXECUTE
and
.B VM_PROT_ALL
as defined in 
.B <mach/vm_prot.h>
. 

Only data which is cached at the time of this call is affected.
When a running thread requires a prohibited
access to cached data, the will issue a 
.B memory_object_data_unlock
call specifying the forms of access
required.
Once all of the actions requested by this call have been completed,
the on the specified reply port.

.SH ARGUMENTS
.TP 15
.B
memory_control
The port, provided by the kernel 
in a 
.B memory_object_init
call, to which cache management requests may be issued.
.TP 15
.B
offset
An offset within a memory object, in bytes.  This must be
page aligned.
.TP 15
.B
size
The amount of cached data (starting at 
.B offset
) to be handled, must
be an integral multiple of the memory object page size.
.TP 15
.B
should_clean
If set, modified data should be written back to the memory manager.
.TP 15
.B
should_flush
If set, the specified cached data should be invalidated, and all
uses of that data should be revoked.
.TP 15
.B
lock_value
A protection value indicating those forms of access that should
.B not
be permitted to the specified cached data.
.TP 15
.B
reply_to
A port on which a 
.B memory_object_lock_completed
call should be issued,
or 
.B PORT_NULL
if no acknowledgement is desired.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
This routine does not receive a reply message (and consequently
has no return value), so only message transmission errors apply.

.SH SEE ALSO
.B memory_object_lock_completed, memory_object_data_unlock

