.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	memory_object_get_attributes.man,v $
.\" Revision 2.2  90/08/07  18:41:03  rpd
.\" 	Created.
.\" 
.TH memory_object_get_attributes 2 12/19/89
.CM 4
.SH NAME
.nf
memory_object_get_attributes  \-  indicate how kernel should handle object
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t memory_object_get_attributes(memory_control,
				object_ready, may_cache_object,
				copy_strategy)
	memory_object_control_t
			memory_control;
	boolean_t	*object_ready;
	boolean_t	*may_cache_object;
	memory_object_copy_strategy_t
			*copy_strategy;


.fi
.ft P
.SH DESCRIPTION

.B memory_object_get_attributes
retrieves the current attributes
associated with the memory object.  

.SH ARGUMENTS
.TP 15
.B
memory_control
The port, provided by the kernel 
in a 
.B memory_object_init
call, to which cache management requests may be issued.
.TP 15
.B
object_ready
When set, the kernel may issue new data and unlock requests on the
associated memory object.
.TP 15
.B
may_cache_object
If set, the kernel may keep data 
associated with this
memory object, even after virtual memory references to it are gone.
.TP 15
.B
copy_strategy
How the kernel should copy regions of the associated
memory object.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
This routine does not receive a reply message (and consequently
has no return value), so only message transmission errors apply.

.SH SEE ALSO
.B memory_object_set_attributes, memory_object_copy

