.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	memory_object_data_unlock.man,v $
.\" Revision 2.2  90/08/07  18:40:43  rpd
.\" 	Created.
.\" 
.TH memory_object_data_unlock 2 12/19/89
.CM 4
.SH NAME
.nf
memory_object_data_unlock  \-  request to unlock paging object
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t memory_object_data_unlock(memory_object, memory_control,
			    offset, length, desired_access)
	memory_object_t	memory_object;
	memory_object_control_t
			memory_control;
	vm_offset_t	offset;
	vm_size_t	length;
	vm_prot_t	desired_access;


.fi
.ft P
.SH DESCRIPTION

.B memory_object_data_unlock
is a request that the memory manager permit at least
the desired access to the specified data cached by the kernel.
A call to 
.B memory_object_lock_request
is expected in response.

.SH ARGUMENTS
.TP 15
.B
.B memory_object
The port that represents the memory object data, as 
supplied to the kernel in a 
.B vm_map
call.
.TP 15
.B
.B memory_control
The request port to which a response is 
requested.  [In the event that a memory object has been supplied 
to more than one the kernel that has made the request.]
.TP 15
.B
.B offset
The offset within a memory object to which this call refers.
This will be page aligned.
.TP 15
.B
.B length
The number of bytes of data, starting at 
.B offset
, to which this
call refers. This will be an integral number of memory object pages.
.TP 15
.B
.B desired_access
A protection value describing the memory access modes which
must be permitted on the specified cached data. One or more of:
.B VM_PROT_READ, VM_PROT_WRITE
or 
.B VM_PROT_EXECUTE
.

.SH DIAGNOSTICS
.TP 25
.B KERN_SUCCESS
Since this routine is called by the kernel, which does not
wait for a reply message, this value is ignored.

.SH SEE ALSO
.B memory_object_lock_request,memory_object_lock_completed

