.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	memory_object_data_error.man,v $
.\" Revision 2.2  90/08/07  18:39:36  rpd
.\" 	Created.
.\" 
.TH memory_object_data_error 2 12/18/89
.CM 4
.SH NAME
.nf
memory_object_data_error  \-  indicates data retrieval failure
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t memory_object_data_error(memory_control,
				offset, size, reason);
	memory_object_control_t
			memory_control;
	vm_offset_t	offset;
	vm_size_t	size;
	kern_return_t	reason;


.fi
.ft P
.SH DESCRIPTION

.B memory_object_data_error
indicates that the memory manager cannot return
the data requested for the given region, specifying a reason for the error.
This is typically used when a hardware error is encountered.

.SH ARGUMENTS
.TP 15
.B
memory_control
The port, provided by the kernel 
in a 
.B memory_object_init
call, to which cache management requests may be issued.
.TP 15
.B
offset
An offset within a memory object, in bytes.  This must be
page aligned.
.TP 15
.B
size
The amount of cached data (starting at 
.B offset
) to be handled.
This must be an integral multiple of the memory object page size.
.TP 15
.B
reason
Could be a Unix error code for a hardware error.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
This routine does not receive a reply message (and consequently
has no return value), so only message transmission errors apply.

.SH SEE ALSO
.B memory_object_data_request, memory_object_data_provided

.SH BUGS

The error code is currently ignored.

