.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	memory_object_copy.man,v $
.\" Revision 2.2  90/08/07  18:39:19  rpd
.\" 	Created.
.\" 
.TH memory_object_copy 2 12/19/89
.CM 4
.SH NAME
.nf
memory_object_copy  \-   part of page object has been copied
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t memory_object_copy(old_memory_object, old_memory_control,
                                offset, length, new_memory_object)           
     memory_object_t		old_memory_object;
     memory_object_control_t	old_memory_control;
     vm_offset_t		offset;
     vm_size_t			length;
     memory_object_t		new_memory_object;



.fi
.ft P
.SH DESCRIPTION
.B memory_object_copy
indicates that a copy has been made of the specified
range of the given original memory object.  
This call includes only the new memory object itself; a 
.B memory_object_init
call will be made on the new memory object after the currently cached pages
of the original object are prepared. After the memory manager receives the
init call, it should reply with the 
.B memory_object_set_attributes
call to
assert the "ready" attribute. The kernel will use the new memory
object, contol and name ports to refer to the new copy.

This call is made when the original memory object had the caching
parameter set to 
.B MEMORY_OBJECT_COPY_CALL
and a user of the object 
has asked the kernel to copy it.

Cached pages from the original memory object at the time of the copy operation
are handled as follows: Readable pages may be silently copied to the new
memory object (with all access permissions). Pages not copied are locked 
to prevent write access.

The new memory object is 
.I temporary
, meaning that the memory manager should
not change its contents or allow the memory object to be mapped in another 
client.  The memory manager may use the 
.B memory_object_data_unavailable
call to indicate that the appropriate pages of the original memory 
object may be used to fulfill the data request.

.SH ARGUMENTS
.TP 15
.B
.B old_memory_object
The port that represents the old memory object date.
.TP 15
.B
.B old_memory_contol
The kernel control port for the old object.
.TP 15
.B
.B offset
The offset within a memory object to which this call refers.
This will be page aligned.
.TP 15
.B
.B length
The number of bytes of data, starting at 
.B offset
, to which this
call refers. This will be an integral number of memory object pages.
.TP 15
.B
.B new_memory_object
A new memory object created by the kernel; see 
synopsis for further description.  Note that all port rights (including
receive rights) are included for the new memory object.

.SH DIAGNOSTICS
.TP 25
.B KERN_SUCCESS
Since this routine is called by the kernel, which does not
wait for a reply message, this value is ignored.

.SH SEE ALSO
.B memory_object_init, memory_object_set_attributes,

.B memory_object_data_unavailable

