.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	mach_task_self.man,v $
.\" Revision 2.2  90/08/07  18:38:52  rpd
.\" 	Created.
.\" 
.TH mach_task_self 2 9/19/86
.CM 4
.SH NAME
.nf
mach_task_self \- return calling thread's task port
.SH SYNOPSIS
.nf
.ft B
#include <mach/mach_traps.h>

mach_port_t mach_task_self();
.fi
.ft P
.SH DESCRIPTION
The \fBmach_task_self\fR system call returns the calling thread's task port.

\fBmach_task_self\fR has an effect equivalent to receiving
a send right for the task port.  \fBmach_task_self\fR
returns the name of the send right.  In particular,
successive calls will increase the calling task's
user-reference count for the send right.
.SH DIAGNOSTICS
.TP 25
MACH_PORT_NULL
A resource shortage prevented the reception of the send right.
.TP 25
MACH_PORT_NULL
The task port is currently null.
.TP 25
MACH_PORT_DEAD
The task port is currently dead.
.SH SEE ALSO
mach_thread_self(2), task_special_ports(2).
.SH BUGS
The file <mach_init.h> redefines \fBmach_task_self\fR
to be a macro returning the value of a global variable.
Before \fBmain\fR is called, libmach code uses the
\fBmach_task_self\fR system call to initialize the global variable.
