.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	mach_reply_port.man,v $
.\" Revision 2.2  90/08/07  18:38:44  rpd
.\" 	Created.
.\" 
.TH mach_reply_port 2 9/19/86
.CM 4
.SH NAME
.nf
mach_reply_port \- create a reply port
.SH SYNOPSIS
.nf
.ft B
#include <mach/mach_traps.h>

mach_port_t mach_reply_port();
.fi
.ft P
.SH DESCRIPTION
The \fBmach_reply_port\fR system call creates
a reply port in the calling task.

\fBmach_reply_port\fR creates a port, giving the calling
task the receive right for the port.  The call returns
the name of the new receive right.

This is very much like creating a receive right
with the \fBmach_port_allocate(2)\fR call,
with two differences.  First, \fBmach_reply_port\fR
is a system call and not an RPC (which requires a reply port).
Second, the port created by \fBmach_reply_port\fR may be
optimized for use as a reply port.
.SH DIAGNOSTICS
.TP 25
MACH_PORT_NULL
A resource shortage prevented the creation of the receive right.
.SH SEE ALSO
mach_port_allocate(2).
