.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	mach_port_set_qlimit.man,v $
.\" Revision 2.2  90/08/07  18:38:19  rpd
.\" 	Created.
.\" 
.TH mach_port_set_qlimit 2 1/13/87
.CM 4
.SH NAME
.nf
mach_port_set_qlimit \- changes the queue limit of a port
.SH SYNOPSIS
.nf
.ft B
#include <mach/mach.h>

kern_return_t
mach_port_set_qlimit(task, name, qlimit)
	task_t task;
	mach_port_t name;
	mach_port_qlimit_t qlimit;
.fi
.ft P
.SH ARGUMENTS
.TP 12
.B
task
The task owning the receive right.
.TP 12
.B
name
\fBtask\fR's name for the receive right.
.TP 12
.B
qlimit
The number of messages which may be queued to this port
without causing the sender to block.
.SH DESCRIPTION
.B mach_port_set_qlimit
changes the queue limit of \fBtask\fR's receive right
named \fBname\fR.  Valid values for \fBqlimit\fR are between zero and
MACH_PORT_QLIMIT_MAX, inclusive.
.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The call succeeded.
.TP 25
KERN_INVALID_TASK
\fBtask\fR was invalid.
.TP 25
KERN_INVALID_NAME
\fBname\fR did not denote a right.
.TP 25
KERN_INVALID_RIGHT
\fBname\fR denoted a right, but not a receive right.
.TP 25
KERN_INVALID_VALUE
\fBqlimit\fR was invalid.
.PP
The \fBmach_port_set_qlimit\fR call is actually an RPC to \fBtask\fR,
normally a send right for a task port, but potentially any send right.
In addition to the normal diagnostic
return codes from the call's server (normally the kernel),
the call may return \fBmach_msg(2)\fR return codes.
.SH SEE ALSO
mach_port_get_receive_status(2), mach_port_set_mscount(2).
