.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	mach_port_allocate.man,v $
.\" Revision 2.2  90/08/07  18:35:54  rpd
.\" 	Created.
.\" 
.TH mach_port_allocate 2 4/13/87
.CM 4
.SH NAME
.nf
mach_port_allocate  \-  creates a port right
.SH SYNOPSIS
.nf
.ft B
#include <mach/mach.h>

kern_return_t
mach_port_allocate(task, right, name)
	task_t task;
	mach_port_right_t right;
	mach_port_t *name;		/* out */
.fi
.ft P
.SH ARGUMENTS
.TP 12
.B
task
The task acquiring the port right.
.TP 12
.B
right
The kind of right which will be created.
.TP 12
.B
name
The task's name for the port right.
.SH DESCRIPTION
\fBmach_port_allocate\fR creates a new right in the specified task.
The new right's name is returned in \fBname\fR.

The \fBright\fR argument takes the following values:
.TP 12
MACH_PORT_RIGHT_RECEIVE
\fBmach_port_allocate\fR
creates a port.  The new port is not a member
of any port set.  It doesn't have any extant send or send-once rights.
Its make-send count is zero, its queue limit is MACH_PORT_QLIMIT_DEFAULT,
and it has no queued messages.
\fBname\fR denotes the receive right for the new port.

\fBtask\fR does not hold send rights for the new port, only the receive right.
\fBmach_port_insert_right(2)\fR and \fBmach_port_extract_right(2)\fR can
be used to convert the receive right into a combined send/receive right.
.TP 12
MACH_PORT_RIGHT_PORT_SET
\fBmach_port_allocate\fR creates a port set.
The new port set has no members.
.TP 12
MACH_PORT_RIGHT_DEAD_NAME
\fBmach_port_allocate\fR creates a dead name.
The new dead name has one user reference.
.PP
The returned \fBname\fR may be any name that wasn't in use.
.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The call succeeded.
.TP 25
KERN_INVALID_TASK
\fBtask\fR was invalid.
.TP 25
KERN_INVALID_VALUE
\fBright\fR was invalid.
.TP 25
KERN_NO_SPACE
There was no room in \fBtask\fR's IPC name space for another right.
.TP 25
KERN_RESOURCE_SHORTAGE
The kernel ran out of memory.
.PP
The \fBmach_port_allocate\fR call is actually an RPC to \fBtask\fR,
normally a send right for a task port, but potentially any send right.
In addition to the normal diagnostic
return codes from the call's server (normally the kernel),
the call may return \fBmach_msg(2)\fR return codes.
.SH SEE ALSO
mach_port_allocate_name(2),
mach_port_insert_right(2),
mach_port_extract_right(2).
