.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	mach_host_self.man,v $
.\" Revision 2.2  90/08/07  18:35:29  rpd
.\" 	Created.
.\" 
.TH mach_host_self 2 9/19/86
.CM 4
.SH NAME
.nf
mach_host_self \- return calling thread's host port
.SH SYNOPSIS
.nf
.ft B
#include <mach/mach_traps.h>

mach_port_t mach_host_self();
.fi
.ft P
.SH DESCRIPTION
The \fBmach_host_self\fR system call returns
the calling thread's host port.

\fBmach_host_self\fR has an effect equivalent to receiving
a send right for the host port.  \fBmach_host_self\fR
returns the name of the send right.  In particular,
successive calls will increase the calling task's
user-reference count for the send right.
.SH DIAGNOSTICS
.TP 25
MACH_PORT_NULL
A resource shortage prevented the reception of the send right.
.SH SEE ALSO
mach_task_self(2), mach_thread_self(2).
