.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	host_processors.man,v $
.\" Revision 2.2  90/08/07  18:35:19  rpd
.\" 	Created.
.\" 
.TH host_processors 2 2/2/89
.CM 4
.SH NAME
.nf
host_processors  \-  gets processor ports for a host
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t host_processors(host_priv, processor_list, processor_count)
    host_priv_t		host_priv;
    processor_array_t	*processor_list;	/* out, ptr to array */
    int			*processor_count;	/* out */


.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
host_priv
Privileged host port for the desired host.
.TP 15
.B
processor_list
The set of processors existing on
.B host_priv
, no particular ordering is guaranteed. 
.TP 15
.B
processor_count
The number of threads in the 
.B processor_list.

.SH DESCRIPTION
.B host_processors
gets send rights to  the processor port for each processor
existing on 
.B host_priv.
This is the privileged port that allows its
holder to control a processor. 
.B processor_list
is an array that is
created as a result of this call. The caller may wish to 
.B vm_deallocate
this array when the data is no longer needed.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The call succeeded.
.TP 25
KERN_INVALID_ARGUMENT
.B host_priv
is not a privileged host port.
.TP 25
KERN_INVALID_ADDRESS
.B processor_count
points to inaccessible memory.

.SH SEE ALSO
.B processor_start, processor_exit, processor_info, processor_control

.SH BUGS
Availability limited.

