.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	host_processor_sets.man,v $
.\" Revision 2.2  90/08/07  18:35:07  rpd
.\" 	Created.
.\" 
.TH host_processor_sets 2 8/13/89
.CM 4
.SH NAME
.nf
host_processor_sets  \-  gets processor_set ports name ports for a host
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t
host_processor_sets(host, processor_set_list, processor_set_count)
    host_t		   host;
    processor_set_array_t  *processor_set_list;	/* out, ptr to array */
    int			   *processor_set_count;	/* out */



.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
host
The host to be affected.
.TP 15
.B
processor_set_list
The set of processor_sets currently existing on
.B host
; no particular ordering is guaranteed. 
.TP 15
.B
processor_set_count
The number of processor_sets in the 
.B processor_set_list.

.SH DESCRIPTION
.B host_processor_sets
gets send rights to the name port for each processor_set
currently assigned to 
.B host.

.B host_processor_set_priv
can be used to obtain the object ports from these if desired.
.B processor_set_list
is an array that is
created as a result of this call. The caller may wish to 
.B vm_deallocate
this array when the data is no longer needed.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The call succeeded.
.TP 25
KERN_INVALID_ARGUMENT
.B host
is not a host.

.SH BUGS
Availability limited.

.SH SEE ALSO
.B host_processor_set_priv, processor_set_create, processor_set_tasks,
.B processor_set_threads

