.\" 
.\" Mach Operating System
.\" Copyright (c) 1990 Carnegie-Mellon University
.\" All rights reserved.  The CMU software License Agreement specifies
.\" the terms and conditions for use and redistribution.
.\" 
.\" 
.\" HISTORY
.\" $Log:	host_kernel_version.man,v $
.\" Revision 2.2  90/08/07  18:34:48  rpd
.\" 	Created.
.\" 
.TH host_kernel_version 2 8/13/89
.CM 4
.SH NAME
.nf
host_kernel_version  \-  return kernel version information for host
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t host_kernel_version(host, version)
	host_t host;
	kernel_version_t *version;		/* out */



.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
host
The host for which information is being requested
.TP 15
.B
version
Character string describing the kernel version executing on 
.B host.

.SH DESCRIPTION
.B host_kernel_version
returns the version string compiled into the kernel executing on
.B host
at the time it was built.  This describes the version of the kernel.
The constant 
.B KERNEL_VERSION_MAX
should be used to dimension storage for the returned string if the
.B kernel_version_t
declaration is not used.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The call succeeded.
.TP 25
KERN_INVALID_ARGUMENT
.B host
was not a host.
.TP 25
KERN_INVALID_ADDRESS
.B version
points to inaccessible memory.

.SH BUGS
Availability limited.

.SH SEE ALSO
.B host_info, host_processors, host_ports, processor_info

