/***************************/
/* (c) IBM Australia 1994  */
/* Author:  Paul Szilard   */
/***************************
Function:
~~~~~~~~~
Lists all USERS in CSV format allowing ready insertion into 
spreadsheets or database files for further analysis or reporting.

Simply redirect the output to save for further use.

Usage: USERS [/H | /NH]

          /H = With    Column Headers
         /NH = Without Column Headers
          /? = Help
           ? = Help

Pre/Co-Reqs: 
       Basic OS/2 REXX. No extensions required in this prog.

Notes: 1) Error handling is non-existant. Check output!
       2) To read into Excel 4, just open redirected output file
          and select Comma as delimiter for text files. Save as
          Normal Excel file.
***************************/
/* Set default: 1= HEADER  0= NO HEADER */
HEADER=0
parse upper arg OPTIONS .
OPTIONS=strip(OPTIONS)
select
   when OPTIONS='/H'  then HEADER=1
   when OPTIONS='/NH' then HEADER=0
   when POS('?',OPTIONS)>0 then do
      call USAGE
      exit
      end  /* Do */
   otherwise nop
end  /* select */

'@net users | rxqueue/fifo'
call PULLQUEUE

j=1
do i=4 to LINE.0-1
   UserId.j=strip(word(LINE.i,1))
   j=j+1
   UserId.j=strip(word(LINE.i,2))
   j=j+1
   UserId.j=strip(word(LINE.i,3))
   j=j+1
end /* do */

/* Drop null ids */
do while UserId.j=''
   j=j-1
end /* do */
UserId.0=j

if HEADER=1 then say '"'USER ID'","'FULL NAME'","'COMMENT'","'USER COMMENT'","'PRIVILEGE'","'OPERATOR'","'LOGON SCRIPT'","'HOME DIR'"'

do i=1 to UserId.0
   '@net user' UserId.i '| rxqueue /fifo'
   call PULLQUEUE
   do j=1 to LINE.0
      R.j=strip(substr(LINE.j,30))
   end /* do */
   say '"'R.1'","'R.2'","'R.3'","'R.4'","'R.7'","'R.8'","'R.21'","'R.22'"'
end /* do */

exit(0)

/*-----------*/
/* Functions */
/*-----------*/
/*************/

PULLQUEUE: procedure expose LINE.
  LINE.0 = queued()
  do i = 1 to LINE.0
    parse pull LINE.i
  end
return

USAGE:
say 'Function:                                                    '
say '~~~~~~~~~                                                    '
say 'Lists all USERS in CSV format allowing ready insertion into  '
say 'allowing ready insertion into spreadsheets or database files '
say 'for further analysis or reporting.                           '
say '                                                             '
say 'Simply redirect the output to save for further use.          '
say '                                                             '
say 'Usage: USERS [/H | /NH]                                    '
say '                                                             '
say '          /H = With    Column Headers                        '
say '         /NH = Without Column Headers                        '
say '          /? = Help                                          '
say '           ? = Help                                          '
say '                                                             '
return
