/***************************/
/* (c) IBM Australia 1994  */
/* Author:  Paul Szilard   */
/***************************
Function:
~~~~~~~~~
Re-establish connection to user's Home directory after it has become
disconnected.

Pre-Req:
~~~~~~~~
Uses WHOAMI from IBM's OS2TOOLS

***************************/
'@whoami | rxqueue /fifo'                       /* Establish USERID */
call pullqueue
parse var line.1 junk '=' USERID
'@net use | find "'USERID'" |rxqueue /fifo'     /* Find HOMEDRIVE   */
call pullqueue
parse var line.1 STATUS DRV DEF
'net use' DRV '/d'                              /* Drop connection  */
if rc=0 then 'net use' DRV USERID               /* Re-Establish     */
else do                                         /* Failed /d        */
  say
  say '   Your Homedrive' DRV 'could not be dropped.'
  say     
  say '   Ensure that none of your applications are trying to access it'
  say '   and then try again. (Example conditions could be file manager,'
  say '   or an application trying to display list of files on' DRV
  say
end /* if */
exit(0)
/*-----------*/
/* Functions */
/*-----------*/
PULLQUEUE: procedure expose LINE.
  LINE.0 = queued()
  do i = 1 to LINE.0
    parse pull LINE.i
  end
return
