/* Force a Single User off the Domain */
arg UserID

if UserID = "" then do
   say "You must supply a current UserID as a parameter"
   return
end

'@rxqueue /clear'

/* Make sure we're running on the right machine */
'@net accounts | rxqueue'
do while queued() > 0
   pull line
   if word(line,1) = "SERVER" & word(line,2) = "ROLE:" then do
      role = word(line,3)
      if role <> "PRIMARY" then do
         say "This utility may only be run on the domain controller"
         return
      end
   end
end

/* Disable the user's account */
'@NET USER' UserID '/ACTIVE:NO >\DEV\NUL 2>&1'

/* Disconnect the user from all resource in the domain */

/* Get all server names */
n = 0
'@net view | rxqueue'
do while queued() > 0
   pull machine .
   if left(machine,2) = '\\' then do
      n = n + 1
      s.n = machine
   end
end

/* Tell each server to disconnect the user, if connected */
do i=1 to n
   '@net admin' s.n '/c net session | rxqueue'
   do while queued() > 0
     pull machine user .
     if left(machine,2) = '\\' & user = UserID then do
       say "Disconnecting" user
       '@net admin' s.n '/c net session' machine '/delete /y'
     end
   end
end

drop s

say
say "User" UserID "has been disconnected and disabled."
say
say "To allow" UserID "to log on in the future, you will need to"
say "re-enable the account using:"
say
say "    NET USER" UserID "/ACTIVE:YES"
say
say "or by using User Profile Management Services."
