/***************************/
/* (c) IBM Australia 1994  */
/* Author:  Paul Szilard   */
/***************************
Function:
~~~~~~~~~
Lists all aliases and their servers, paths, etc in CSV format
allowing ready insertion into spreadsheets or database files
for further analysis or reporting.

Simply redirect the output to save for further use.

Usage: ALIASES [/H | /NH]

          /H = With    Column Headers
         /NH = Without Column Headers
          /? = Help
           ? = Help

Pre/Co-Reqs: 
       Basic OS/2 REXX. No extensions required in this prog.

Notes: 1) Error handling is non-existant. Check output!
       2) To read into Excel 4, just open redirected output file
          and select Comma as delimiter for text files. Save as
          Normal Excel file.
***************************/
/* Set default: 1= HEADER  0= NO HEADER */
HEADER=0
parse upper arg OPTIONS .
OPTIONS=strip(OPTIONS)
select
   when OPTIONS='/H'  then HEADER=1
   when OPTIONS='/NH' then HEADER=0
   when POS('?',OPTIONS)>0 then do
      call USAGE
      exit
      end  /* Do */
   otherwise nop
end  /* select */

'@net alias | rxqueue/fifo'
call PULLQUEUE

do i=4 to LINE.0-1
   ALIAS.i=word(LINE.i,1)
end /* do */

if HEADER=1 then say '"'ALIAS'","'DESCRIPTION'","'SERVER'","'PATH'","'WHEN SHARED'","'MAX USERS'"'

do i=4 to LINE.0-1
   '@net alias' ALIAS.i '| rxqueue /fifo'
   call PULLQUEUE
   do j=2 to 6
      parse var LINE.j title ':' FIELD.j
      field.j=strip(field.j)
   end /* do */
   say '"'ALIAS.i'","'FIELD.2'","'field.3'","'field.4'","'field.5'","'field.6'"'
end /* do */

exit(0)

/*-----------*/
/* Functions */
/*-----------*/

PULLQUEUE: procedure expose LINE.
  LINE.0 = queued()
  do i = 1 to LINE.0
    parse pull LINE.i
  end
return

USAGE:
say 'Function:                                                    '
say '~~~~~~~~~                                                    '
say 'Lists all aliases and their servers, paths, etc in CSV format'
say 'allowing ready insertion into spreadsheets or database files '
say 'for further analysis or reporting.                           '
say '                                                             '
say 'Simply redirect the output to save for further use.          '
say '                                                             '
say 'Usage: ALIASES [/H | /NH]                                    '
say '                                                             '
say '          /H = With    Column Headers                        '
say '         /NH = Without Column Headers                        '
say '          /? = Help                                          '
say '           ? = Help                                          '
say '                                                             '
return
