/*---------------------------------------------------------------------------*\
|  Check Lan Server Status                    (C) Alain Rykaert - MAR96-NOV98 |
\*---------------------------------------------------------------------------*/
    Version = '2.34'
    Say '* LSST Version' Version

    Parse Upper Arg ServerName Option

    If Option = '/STAT'                        /* check the statistics flag*/
      Then Stat = 1
      Else Stat = 0

    Call Init                                   /* load DLL's & other stuff*/

    If ServerName = ''
      Then Do
             Say '*'
             Say '* LAN Server Check & Statistics'
             Say '*'
             Say '* Usage: LSC {*} {ServerName} {/STAT}'
             Say '*'
             Say '* Sample: LSC \\DC02 /STAT'
             Say '*'
             Exit X2D('1600')
           End
      Else Nop

    If ServerName = '*'
      Then Do
             RC = NetGetInfo(350, 'WkstaInfo','')
             If RC = 0
               Then ServerName = WkstaInfo.ComputerName
               Else Call ChkError RC
           End
      Else ServerName = ServerName

    ServerName = Strip(ServerName,'L','\')

    Say '* Server Name:' '\\'ServerName

    RC = NetGetInfo(370, 'ServerModalInfo', '\\'ServerName)
    If RC = 0
      Then Do
             LSRFile = '\\'ServerName'\ibmlan$\ibmlan.ini'
             Say Left('*',50,'-')
             Say '* Get Accounts:'
             Say Left('*',50,'-')
             ServerRole = ServerModalInfo.Role
             DCName = ServerModalInfo.Primary

             Say '  Server Role:' ServerRole
             If WordPos('Primary', ServerRole) > 0
               Then PDC = 1                                 /* check if PDC*/
               Else PDC = 0
             If WordPos('Primary', ServerRole) > 0 |,
                WordPos('Backup', ServerRole)  > 0
               Then DCCheck = 1               /* check if Domain Controller*/
               Else DCCheck = 0
             Say '  Domain controller for requester domain: \\'DCName

             Say Left('*',50,'-')
             Say '* Get Users:'
             Say Left('*',50,'-')
             Call NetEnumerate 280, 'DCUsers', '\\'DCName
             Say '  Number of users defined on \\'DCName ':' DCUsers.0
             If PDC = 1
               Then Nop
               Else Do
                      Call NetEnumerate 280, 'Users', '\\'ServerName
                      Say '  Number of users replicated to \\'ServerName ':' Users.0
                    End
           End
      Else Call ChkError RC

    Say Left('*',50,'-')
    Say '* Get services:'
    Say Left('*',50,'-')
    Call NetEnumerate 170, 'ServiceInfo', '\\'ServerName
    ServiceInfo = ''
    If ServiceInfo.0 > 5                   /* if more than 5 split the line*/
      Then Do
             Do i = 1 to 5
               ServiceInfo = ServiceInfo ServiceInfo.i
             End
             ServiceInfo = ServiceInfo '0A0D20'x
             Do i = 6 to ServiceInfo.0
               ServiceInfo = ServiceInfo ServiceInfo.i
             End
           End
      Else Do
             Do i = 1 to ServiceInfo.0
               ServiceInfo = ServiceInfo ServiceInfo.i
             End
           End
    Say ' ' || ServiceInfo

    If DCCheck = 1                              /* either Primary or Backup*/
      Then Do
              Say Left('*',50,'-')
              Say '* Check DCDB Replicator:'
              Say Left('*',50,'-')
              If WordPos('DCDBREPL', ServiceInfo) > 0
                Then Say '  DCDB replicator running'
                Else Do
                        Call Beep 2000,50
                        Say '  DCDB replicator NOT running' Left('<',25,'-')
                     End
              Say '  Checking DCDB tree:'
              Dir.0 = 9
              Dir.1 = 'apps'
              Dir.2 = 'devices'
              Dir.3 = 'data'
              Dir.4 = 'files'
              Dir.5 = 'images'
              Dir.6 = 'lists'
              Dir.7 = 'printers'
              Dir.8 = 'scripts'
              Dir.9 = 'users'

              Do i = 1 to Dir.0
                Call SysFileTree '\\'ServerName'\ibmlan$\dcdb\'Dir.i'\*.rp$', 'Stem', 'FO'
                If Stem.0 = 0
                  Then Status = '-none-'
                  Else Do
                         x = LastPos('\', Stem.1) + 1
                         Parse Value Substr(Stem.1, x) With Status '.' .
                       End
                If Status = 'OK'
                  Then Check = ' '
                  Else Check = '*'
                Say ' ' i Left(Translate(Dir.i),9) Check,
                          Left(Status,9) Stream(Stem.1, 'C', 'Query DateTime')
              End
              Call SysFileTree '\\'ServerName'\ibmlan$\dcdb\users\', 'Stem', 'DO'
              Say '     >' Stem.0 'directories'
              If PDC = 1
                Then Nop
                Else Do
                       Call SysFileTree '\\'DCName'\ibmlan$\dcdb\users\', 'Stem', 'DO'
                       Say '  Directories on \\'DCName '>' Stem.0
                     End
           End
      Else Nop

    If Stat = 1
      Then Do
             Say Left('*',50,'-')
             Say '* Statistics:'
             Say Left('*',50,'-')
             Call NetGetInfo 160, 'ServerInfo', '\\'ServerName
             Call NetGetInfo 195, 'StatisticsInfo', '\\'ServerName, 1, 0
             Call NetEnumerate 60, 'FileInfo', '\\'ServerName
             Call NetEnumerate 190, 'Shares', '\\'ServerName
             Call NetEnumerate 180, 'Sessions', '\\'ServerName

             Say '  Statistics Time:' Strip(StatisticsInfo.Start,'T','0A'x)

             MaxConnections = ServerInfo.Connections
             ActiveConnections = 0
             Do i = 1 to Sessions.0
               ActiveConnections = ActiveConnections + Sessions.i.Num_Conns
             End

             Say '  Number of shares:' Shares.0'/'ServerInfo.Shares
             SharesOnDemand = 0
             Do i = 1 to Shares.0
               If WordPos('ADMIN$', Shares.i)    > 0 |,
                  WordPos('DCDBREPL$', Shares.i) > 0 |,
                  WordPos('NETLOGON', Shares.i)  > 0 |,
                  WordPos('IBMLAN$', Shares.i)   > 0 |,
                  WordPos('IPC$', Shares.i)      > 0 |,
                  WordPos('REPL$', Shares.i)     > 0 |,
                  Length(Shares.i) = 2
                  Then Nop
                  Else SharesOnDemand = SharesOnDemand + 1
             End
             Say '  Shares on demand:' SharesOnDemand

             Say '  Total of used sessions:' StatisticsInfo.Sopens
             Say '  Number of active sessions:' Sessions.0
             Say '  Auto Disconnect Parameter:' ServerInfo.Disc
             Say '  Auto Disconnects:' StatisticsInfo.Stimedout
             Say '  Closed by Errors:' StatisticsInfo.Serrorout
             Say '  Number of active connections:' ActiveConnections'/'ServerInfo.Connections
             Say '  Password Violations:' StatisticsInfo.PwErrors
             Say '  Permission Errors:' StatisticsInfo.PermErrors
             Say '  System Errors:' StatisticsInfo.SysErrors
             Say '  Number of total opened files:' StatisticsInfo.Fopens
             Say '  Number of current open files:' FileInfo.Count'/'ServerInfo.OpenFiles
             Say '  Total Bytes TX:' StatisticsInfo.BytesSent Trunc((Format(StatisticsInfo.BytesSent,,0,0) / 1000)) 'KB'
             Say '  Total Bytes RX:' StatisticsInfo.BytesRcvd Trunc((Format(StatisticsInfo.BytesRcvd,,0,0) / 1000)) 'KB'
             Say '  Total Bytes TX+RX:' Trunc((Format(StatisticsInfo.BytesSent,,0,0) + Format(StatisticsInfo.BytesRcvd,,0,0)) / 1000) 'KB'
             Say '  Buffers Needed:' StatisticsInfo.ReqBufNeed
             Say '  Large Buffers Needed:' StatisticsInfo.BigBufNeed
             Say '  Total print jobs queued:' StatisticsInfo.Jobsqueued
             Say '  Average response time:' StatisticsInfo.Avresponse

             Call GetNBStat ServerName                 /* get NetBIOS stats*/
           End
      Else Nop

    Exit X2D('FE00')

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'
    BootDrive = Left(Value('COMSPEC',,'OS2ENVIRONMENT'),2)

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = ''                      /* Check for Lan Server Drive Letter*/
    PPath = Value('PATH',,'OS2ENVIRONMENT')
    x = Pos('IBMLAN\NETPROG', PPath) -3
    If x > 0
      Then LSRDrive = SubStr(PPath, x, 2)
      Else Do
             Say '! Could not determine the Lan Requester path' '07'x
             Exit X2D('1604')
           End

    If Stream(LSRDrive'\ibmlan\netlib\lsrxut.dll', 'C', 'Query Exists') <> ''
      Then Do
             If RxFuncQuery('LoadLSRXUTFuncs')
               Then Do
                      Call RxFuncAdd 'LoadLsRxutFuncs', 'LSRXUT', 'LoadLsRxutFuncs'
                      Call LoadLsRxutFuncs
                    End
               Else Nop
           End
      Else Do
             Say '! Could not find' LSRDrive'\IBMLAN\NETLIB\LSRXUT.DLL' '07'x
             Exit X2D('0800')
           End

    Return

 CHKERROR:/* ----------------------------------------------------------------*/

    Parse Arg RCode

    Say '! Error:' RCode '07'x
    Exit X2D('1600')

    Return

 GETNBSTAT:/* ---------------------------------------------------------------*/

    Parse Arg ServerName

    LAA         = ''
    UAA         = ''
    FreeNCB     = ''
    MaxNCB      = ''
    PendingSess = ''
    MaxSess     = ''
    UsedNames   = ''
    NumSess     = ''
    NumNCB      = ''

    If Stream(BootDrive'\os2\nbjdstat.exe', 'C', 'Query Exists') <> ''
      Then Nop
      Else Do
             Say '* Could not find' BootDrive'\OS2\NBJDSTAT.EXE' '07'x
             Exit X2D('0800')
           End

    TempFile = BootDrive'\os2\lsc.tmp'

   'nbjdstat' ServerName '/v >' TempFile
    If RC = 0
      Then Do
             Do While Lines(TempFile)
               LLine = LineIn(TempFile)
               Select
                 When Left(LLine,11) = 'MAC Address'
                   Then LAA = Translate(Space(SubStr(LLine, 15),0))
                 When Left(LLine,26) = 'Universal Adapter Address'
                   Then UAA = SubStr(LLine, 27)
                 When Left(LLine,19) = 'Number of Free NCBs'
                   Then FreeNCB = SubStr(LLine, LastPos('.',LLine) +1)
                 When Left(LLine,22) = 'Configured NCB maximum'
                   Then MaxNCB = SubStr(LLine, LastPos('.',LLine) +1)
                 When Left(LLine,26) = 'Number of pending sessions'
                   Then PendingSess = SubStr(LLine, LastPos('.',LLine) +1)
                 When Left(LLine,26) = 'Configured session maximum'
                   Then MaxSess = SubStr(LLine, LastPos('.',LLine) +1)
                 When Left(LLine,24) = 'Number of names in table'
                   Then UsedNames = SubStr(LLine, LastPos('.',LLine) +1)
                 Otherwise Nop
               End
               If PendingSess > 0 & MaxSess > 0
                 Then Do
                        NumSess = PendingSess || '/'MaxSess
                        NumNCB = MaxNCB - FreeNCB || '/'MaxNCB
                      End
                 Else Nop
             End
             Say Left('*',50,'-')
             Say '* NIC:'
             Say Left('*',50,'-')
             Say '  Local Adapter Address:' LAA
             Say '  Universal Adapter Address:' UAA
             Say '  Number of sessions:' NumSess
             Say '  Number of NCBs:' NumNCB
             Say '  Number of names:' UsedNames
           End
      Else Say '! Could not get NetBIOS statistics from' ServerName '07'x

    Call Stream TempFile, 'C', 'Close'               /* delete the tmp file*/
    Call SysFileDelete(TempFile)

    Return

