/* KeybUSBR - switches between US and BR 274 keyboards

   Use it if you like it. Don't if you don't. No legalese.

   (c) 1999 Marcus C. de Geus
            marcus@degeus.com
            http://www.degeus.com

   **************************************************/


signal on Halt                                                                   /* handle halt condition */

if (\LoadREXXUtils()) then                                                       /* if we cannot load the REXX utilities */
do
 call Halt                                                                       /* quit */
end

parse source . . ProgSpec                                                        /* get ProgSpec */
SourceDir = filespec('D',ProgSpec)||filespec('P',ProgSpec)                       /* the source directory name */

QueueName = rxqueue('CREATE')                                                    /* get a queue name */
call rxqueue 'SET',QueueName                                                     /* prepare the queue */

'keyb | rxqueue '||QueueName                                                     /* call KEYB and send the output to the queue */

parse pull  . . . Keyboard                                                       /* get the data we want */
call rxqueue 'DELETE',QueueName                                                  /* get rid of the queue */

if (Keyboard = 'BR.') then                                                       /* if we have a BR keyboard */
do
 'keyb US'                                                                       /* switch to the US keyboard */
 call syssetobjectdata '<KEYB_US_BR274>','ICONFILE='||SourceDir||'keybisus.ico'  /* and change the icon */
end
else                                                                             /* if we've got a US keyboard */
do
 'keyb BR 274'                                                                   /* switch to the Brazilian keyboard */
 call syssetobjectdata '<KEYB_US_BR274>','ICONFILE='||SourceDir||'keybisbr.ico'  /* and change the icon */
end

call Halt                                                                        /* quit */


/***************************************************************/

LoadREXXUtils: procedure                                                         /* loads the REXX utilities library */

Result = 1                                                                       /* start with a good result */

if rxfuncquery('SysLoadFuncs') then                                              /* if it is not already loaded */
do
 if (rxfuncadd('SysLoadFuncs','RexxUtil','SysLoadFuncs') >< 0) then              /* if we cannot add it */
 do
  call beep 333,333                                                              /* signal */
  say 'Error : Cannot register Rexx Utilities library'                           /* report */
  Result = 0                                                                     /* bad result */
 end
 else                                                                            /* if we can add it */
 do
  if (SysLoadFuncs() = 0) then                                                   /* if we cannot load it */
  do
   say 'Error : Cannot load Rexx Utilities library'                              /* report */
   Result = 0                                                                    /* bad result */
  end
 end
end

return Result                                                                    /* end of LoadREXXUtils */


/***************************************************************/

Halt:                                                                            /* handle halt condition */

exit                                                                             /* that's all, folks! */
