/* Installs KeybUSBR.CMD and icons in target directory
   and creates program object on desktop.

   Use it if you like it. Don't if you don't. No legalese.

   (c) 1999 Marcus de Geus
            marcus@degeus.com
            http://www.degeus.com

   **************************************************/

signal on Halt                                                                                                     /* handle halt condition */

if (\LoadREXXUtils()) then                                                                                         /* if we cannot load the REXX utilities */
do
 call Halt                                                                                                         /* quit */
end

parse source . . ProgSpec                                                                                          /* get ProgSpec */
SourceDir = filespec('D',ProgSpec)||filespec('P',ProgSpec)                                                         /* the source directory name */

Destination = GetLoc('Enter the new location for the KeybUSBR files:')                                             /* get the destination folder */

if (Destination = '') then                                                                                         /* if we have no destination */
do
 call beep 333,333                                                                                                 /* signal */
 say 'Aborting installation'                                                                                       /* report */
 call Halt                                                                                                         /* just quit */
end

say 'Copying program files to '||Destination                                                                       /* report */

'@copy "'||SourceDir||'keybinst.cmd " "'||Destination||'" >NUL'                                                         /* copy this file to the destination folder */
'@copy "'||SourceDir||'keybusbr.cmd " "'||Destination||'" >NUL'                                                         /* copy this file to the destination folder */
'@copy "'||SourceDir||'keybisus.ico " "'||Destination||'" >NUL'                                                         /* copy this file to the destination folder */
'@copy "'||SourceDir||'keybisbr.ico " "'||Destination||'" >NUL'                                                         /* copy this file to the destination folder */
'@copy "'||SourceDir||'readme.txt " "'||Destination||'" >NUL'                                                           /* copy this file to the destination folder */

say 'Creating program object on desktop'                                                                           /* report */

Settings = 'EXENAME='||Destination||'\KEYBUSBR.CMD;MINIMIZED=YES;PROGTYPE=WINDOWABLEVIO;OBJECTID=<KEYB_US_BR274>'  /*settings for the program object */
if (\syscreateobject('WPProgram','Keyboard US/BR274','<WP_DESKTOP>',Settings)) then                                /* create the program object on the desktop */
do
 call beep 333,333                                                                                                 /* signal */
 say 'ERROR: The KeybUSBR program object could not be created on the desktop'                                      /* report */
 call Halt                                                                                                         /* and quit */
end

say 'Setting program object icon to match keyboard state'                                                          /* report */
'@cmd.exe /c '||Destination||'\keybusbr.cmd >NUL'                                                                  /* run the program once to set the icon to match the keyboard state */

say ''                                                                                                             /* empty line */
say 'Use the Keyboard US/BR 274 program to change between US and BR 274 keyboards.'                                /* report */
say 'The program object icon will be set to match the keyboard state.'                                             /* report */

call Halt                                                                                                          /* and quit */


/*****************************************************************/

GetLoc: procedure                                                                                                  /* gets RexxMail destination folder */

parse arg Message                                                                                                  /* get the message */

say Message                                                                                                        /* report */

parse pull Location                                                                                                /* get the location*/

Location = strip(Location,'B',' ')                                                                                 /* get rid of any leading and trailing blanks */
Location = strip(Location,'T','\')                                                                                 /* get rid of any trailing backslash */
if (Location = '') then                                                                                            /* if we have nothing */
do
 say 'No location entered'                                                                                         /* report */
 return ''                                                                                                         /* return empty */
end

DriveLetter = filespec('D',Location)                                                                               /* get any drive letter from the new location */
if (DriveLetter = '') then                                                                                         /* if there is no drive letter */
do
 say 'The location must include a drive letter'                                                                    /* report */
 return ''                                                                                                         /* return empty */
end

call sysfiletree Location,'Loc.','DO'                                                                              /* look for the new location */
if (Loc.0 = 0) then                                                                                                /* if it is not found */
do
 say '"'||Location||'" does not exist; should the directory be created?'                                           /* report */
 say 'Type Y to confirm, any other key to abort; finish with [Enter]'                                              /* report */
 parse upper pull Confirm                                                                                          /* get a reply in upper case */
 Confirm = strip(Confirm,'B',' ')                                                                                  /* get rid of blanks */
 if (substr(Confirm,1,1) >< 'Y') then                                                                              /* if it is not a yes */
 do
  return ''                                                                                                        /* return empty */
 end

 say 'Creating directory: '||Location                                                                              /* report */
 if (sysmkdir(Location) >< 0) then                                                                                 /* if we cannot create the new location folder */
 do
  say 'Cannot create '||Location                                                                                   /* report */
  return ''                                                                                                        /* return empty */
 end

end

return Location                                                                                                    /* return with the new location */


/***************************************************************/

LoadREXXUtils: procedure                                                                                           /* loads the REXX utilities library */

Result = 1                                                                                                         /* start with a good result */

if rxfuncquery('SysLoadFuncs') then                                                                                /* if it is not already loaded */
do
 if (rxfuncadd('SysLoadFuncs','RexxUtil','SysLoadFuncs') >< 0) then                                                /* if we cannot add it */
 do
  call beep 333,333                                                                                                /* signal */
  say 'Error : Cannot register Rexx Utilities library'                                                             /* report */
  Result = 0                                                                                                       /* bad result */
 end
 else                                                                                                              /* if we can add it */
 do
  if (SysLoadFuncs() = 0) then                                                                                     /* if we cannot load it */
  do
   say 'Error : Cannot load Rexx Utilities library'                                                                /* report */
   Result = 0                                                                                                      /* bad result */
  end
 end
end

return Result                                                                                                      /* end of LoadREXXUtils */

/*****************************************************************/

Halt:                                                                                                              /* handles halt condition */

say ''                                                                                                             /* empty line */
say 'End of '||ProgSpec||'; Press [Enter]'                                                                         /* report */
parse pull .                                                                                                       /* get a reply */

exit                                                                                                               /* that's all, folks! */
