#ifndef lint
static char Rcs_Id[] =
    "$Id: term_os2.c,v 1.1 2002/03/01 01:25:00 stream Exp $";
#endif

#include "config.h"
#include "ispell.h"
#include "proto.h"
#include "msgs.h"

#include <limits.h>
#include <signal.h>
#include <errno.h>

#define INCL_ERRORS
#define INCL_DOSPROCESS
#define INCL_KBD
#define INCL_VIO
#include <os2.h>

jmp_buf safewritejmpbuf;
int     safewrite_active;

void erase(void)
{
	printf("\x1B[2J");
}

void move(int row, int col)
{
	printf("\x1B[%u;%uH", row+1, col+1);
}

void inverse(void)
{
	printf("\x1B[7m");
}

void normal(void)
{
	printf("\x1B[0m");
}

void backup(void)
{
	printf("\b");
}

void terminit(void)
{
	VIOMODEINFO mode;

	if (outfile != stdout)
		setbuf(stdout, NULL);
	setbuf(stderr, NULL);

	mode.cb = sizeof(mode);
	if (VioGetMode(&mode, 0))
	{ co = 80;	 li = 25;	}
	else
	{ co = mode.col; li = mode.row; }

#if MAX_SCREEN_SIZE > 0
	if (li > MAX_SCREEN_SIZE)
		li = MAX_SCREEN_SIZE;
#endif /* MAX_SCREEN_SIZE > 0 */
#if MAXCONTEXT == MINCONTEXT
	contextsize = MINCONTEXT;
#else /* MAXCONTEXT == MINCONTEXT */
	if (contextsize == 0)
#ifdef CONTEXTROUNDUP
		contextsize = (li * CONTEXTPCT + 99) / 100;
#else /* CONTEXTROUNDUP */
	contextsize = (li * CONTEXTPCT) / 100;
#endif /* CONTEXTROUNDUP */
	if (contextsize > MAXCONTEXT)
		contextsize = MAXCONTEXT;
	else if (contextsize < MINCONTEXT)
		contextsize = MINCONTEXT;
#endif /* MAX_CONTEXT == MIN_CONTEXT */
	/*
	 * Insist on 2 lines for the screen header, 2 for blank lines
	 * separating areas of the screen, 2 for word choices, and 2 for
	 * the minimenu, plus however many are needed for context.  If
	 * possible, make the context smaller to fit on the screen.
	 */
	if (li < contextsize + 8  &&  contextsize > MINCONTEXT)
	{
		contextsize = li - 8;
		if (contextsize < MINCONTEXT)
			contextsize = MINCONTEXT;
	}
	if (li < MINCONTEXT + 8)
		(void) fprintf (stderr, TERM_C_SMALL_SCREEN, MINCONTEXT + 8);

	uerasechar = 8;
	ukillchar  = 127;

	signal(SIGINT, done);
}

SIGNAL_TYPE done (int signo)
{
	(void) signo;
	/*  printf("Signal: done. Exiting\n"); */
	fcloseall();
	if (tempfile[0] != '\0')
		(void) unlink (tempfile);
	exit (0);
	return 0; /* shall not be here */
}

int shellescape(char *buf)
{
	char *processor;
	char args[256];
	char badobj[MAXPATHLEN];
	int rc;
	RESULTCODES result;
	int ret = 1;
	int n;

	processor = getenv("COMSPEC");
	if (processor == NULL)
		processor = "CMD.EXE";

	n = sprintf(args, "%s", processor)+1;  /* create argv[0] */
	if (*buf == 0)			   /* no arguments */
		args[n++] = 0;
	else
		n += sprintf(args+n, "/C %.*s", sizeof(args)-n-4, buf)+1;
	args[n] = 0;			/* terminating NUL */

	if (rc = DosExecPgm(badobj, sizeof(badobj)-1, EXEC_SYNC, args, NULL, &result, processor))
	{
		fprintf(stderr, "DosExecPgm() failed for module '%s', rc = %d\n", badobj, rc);
		ret = 0;
	}
	fprintf(stderr, "Press and key to return...");
	GETKEYSTROKE();
	return ret;
}

#ifdef __WATCOMC__

int mkstemp(char *buf)
{
	char *p;
	HFILE f;
	unsigned n, rc;
	char localbuf[10];
	ULONG action;

#if INT_MAX > 999999ul
#define _Margin 999999ul
#else
#define _Margin INT_MAX
#endif

	p = strstr(buf, "XXXXXX");
	if (p == NULL)
		return -1;
	for (n = 0; n < _Margin; n++)
	{
		sprintf(localbuf, "%06.6d", n);
		memcpy(p, localbuf, 6);
		switch (rc = DosOpen(buf, &f, &action, 0, FILE_ARCHIVED, OPEN_ACTION_CREATE_IF_NEW + OPEN_ACTION_FAIL_IF_EXISTS, OPEN_SHARE_DENYNONE + OPEN_ACCESS_READWRITE, NULL))
		{
		case 0:
			DosClose(f);
			return open(buf, O_RDWR | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE);
		case ERROR_OPEN_FAILED:
			break;
		default:
			fprintf(stderr, "mktemp() failure, rc = %d. hit a key...\n", rc);
			GETKEYSTROKE();
			return -1;
		}
	}
	return -1;
}

FILE *popen(char *name, char *mode)
{
	FILE *f;

	if (mode[0] != 'r' || mode[1] != 0)
	{
		errno = EINVAL;
		return NULL;
	}

	f = tmpfile();
	if (f)
	{
		char *b;
		int rc;

		b = malloc(strlen(name) + 20);

		if (b == NULL)
			rc = -1;
		else
		{
			sprintf(b, "%s 1>&%d", name, fileno(f));

			rc = system(b);

			free(b);

			setmode(fileno(f), O_TEXT);
			fseek(f, 0, SEEK_SET);
		}

		if (rc == -1)
		{
			fclose(f);
			f = NULL;
		}
	}
	return f;
}

#endif /* __WATCOMC__ */

extern char **_argv;

static char ispathchar(char c)
{
	return c == ':' || c == '/' || c == '\\';
}

char *lastpathchar(char *c)
{
	char *lastchar;

	for (lastchar = NULL; *c; c++)
		if (ispathchar(*c))
			lastchar = c;
	return lastchar;
}

char os2_LIBDIR[MAXPATHLEN];
char os2_TEMPNAME[MAXPATHLEN];

char *os2_init(char *argv0)
{
	char *p;

	/* Set os2_TEMPNAME using temp directories */

	p = getenv("TEMP");
	if (p == NULL)
	{
		p = getenv("TMP");
		if (p == NULL)
		{
			p = getenv("TEMPDIR");
			if (p == NULL)
				p = ".";
		}
	}

	p = lastpathchar(strcpy(os2_TEMPNAME, p)); /* append slash if not */
	if (p == NULL || p[1] != 0)
		strcat(os2_TEMPNAME, "/");
	strcat(os2_TEMPNAME, "isXXXXXX.tmp");

	/* Set os2_LIBDIR using home dir and 'lib' subdirectory */

	p = lastpathchar(strcpy(os2_LIBDIR, argv0));
	if (p != NULL) /* Have dir - next char will be short argv[0] */
	{
		p++;
		argv0 += (p - os2_LIBDIR);
	}
	else  /* No dir. Keep argv[0] as is */
		p = os2_LIBDIR;
	strcpy(p, "lib");

	return argv0;
}

int os2_GETKEYSTROKE(void)
{
	int rc;
	KBDKEYINFO data;

	for (;;)
	{
		if (rc = KbdCharIn(&data, IO_WAIT, 0))
		{
			fprintf(stderr, "OS/2 Keyboard error, rc = %d\n", rc);
			done(0);
		}
		if ((data.fbStatus & 2) && (data.chChar == 0 || data.chChar == 0xE0))
			continue;
		return data.chChar;
	}
}

#if 0
/*
 * Have to rewrite this because damn One-Unix-Way programmers never do
 * error and free space checks
 */

void update_file (char *filename, struct stat * statbuf)
{
	/*
	 * Copy from tempfile to filename. Create backup of filename if reqd.
	 */

	char		bakfile[MAXPATHLEN];
	char		*fname;
	char		*lastext;
	int			rc;
	(void)		statbuf; /* NOTUSED */

	sprintf(bakfile, "%.*s", sizeof(bakfile)-sizeof(BAKEXT)-1, filename);
	fname = lastpathchar(bakfile);
	if (fname == NULL)
		fname = bakfile;
	else
		fname++;
	lastext = rindex(fname, '.');
	if (lastext)
		*lastext = 0;
	strcat(bakfile, BAKEXT);

	if (stricmp(filename, bakfile))
		unlink(bakfile);
	if (rename(filename, bakfile))
	{
		fprintf(stderr, "Cannot rename '%s' to '%s'... (press space)", filename, bakfile);
		while (GETKEYSTROKE() != ' ')
			;
		return;
	}
	if (rc = DosCopy(tempfile, filename, DCPY_EXISTING))
	{
		fprintf(stderr, "DosCopy('%s' to '%s') failed, rc = %d... (press space)", tempfile, filename, rc);
		while (GETKEYSTROKE() != ' ')
			;
		return;
	}
	if (xflag && stricmp(filename, bakfile))
		unlink(bakfile);
}
#endif

void spaceabort(void)
{
	if (safewrite_active >= 0)
	{
		fprintf(stderr, "ispell: Disk write error (not enough disk space)\n");
		sleep(2);
	}
	if (safewrite_active > 0)
		longjmp(safewritejmpbuf, -1);
	safewrite_active = -1;
}

void safe_putc(int __c, FILE *__fp)
{
	if (putc(__c, __fp) == EOF)
		spaceabort();
}

