#include <stdio.h>

static unsigned char
koi82alt[] = {
 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e,
 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e,
 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e,
 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e,
 0x2e, 0x2e, 0x2e, 0xf1, 0x2e, 0x2e, 0x2e, 0x2e,
 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e,
 0x2e, 0x2e, 0x2e, 0xf0, 0x2e, 0x2e, 0x2e, 0x2e,
 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e,
 0xee, 0xa0, 0xa1, 0xe6, 0xa4, 0xa5, 0xe4, 0xa3,
 0xe5, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae,
 0xaf, 0xef, 0xe0, 0xe1, 0xe2, 0xe3, 0xa6, 0xa2,
 0xec, 0xeb, 0xa7, 0xe8, 0xed, 0xe9, 0xe7, 0xea,
 0x9e, 0x80, 0x81, 0x96, 0x84, 0x85, 0x94, 0x83,
 0x95, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e,
 0x8f, 0x9f, 0x90, 0x91, 0x92, 0x93, 0x86, 0x82,
 0x9c, 0x9b, 0x87, 0x98, 0x9d, 0x99, 0x97, 0x9a
};
int main (int argc /*, char**argv*/)
{
   int c;
   int err;

   if (argc != 1) {
      fprintf(stderr,	"This program does not accept any arguments. It takes data from standard input\n"
			"and writes results to standard output.\n"
			"It can used by russian users to convert files between\n"
			"different cyrillic encodings.\n"
			);
      return 1;
   }

   err = 0;
   while ((c = getchar()) != EOF)
      if (putchar( (c < 128) ? c : koi82alt[(c & 0xFF) - 128]) == EOF)
	 {
	 err = 1;
	 break;
	 }
   if (fclose(stdout))
      err = 1;
   if (err)
      {
      fprintf(stderr, "KOI2ALT: error writing output file\n");
      return 1;
      }
   return 0;
}
