/****************************************************************************/
/*                                                                          */
/*  The FreeType project - a free and portable quality TrueType renderer.   */
/*                                                                          */
/*  Copyright 1996, 1997 by                                                 */
/*  D. Turner, R.Wilhelm, and W. Lemberg                                    */
/*                                                                          */
/*  lint : a simple TrueType instruction tester.                            */
/*                                                                          */
/*  NOTE : This is just a test program that is used to show off and         */
/*         debug the current engine; which is still in alpha. In no         */
/*         way does it shows the final high-level interface that            */
/*         client applications will use. Wait for at least a beta for       */
/*         this.                                                            */
/*                                                                          */
/****************************************************************************/

#ifdef ARM
#include "std.h"
#include "graflink.h"
#endif

#include "tttypes.h"
#include "tterror.h"
#include "ttcalc.h"
#include "tttables.h"
#include "ttmemory.h"
#include "ttraster.h"
#include "ttindex.h"
#include "ttins.h"
#include "ttfile.h"
#include "ttexec.h"
#include "tttables.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>    /* libc ANSI */


#ifdef ARM
#include "armsup.c" /* pull in our routines */
#endif

#define  Font_Buff_Size     256000     /* this buffer holds all     */
                                       /* font specific data.       */

  TT_Stream         stream;
  PResident_Record  resident;
  PInstance_Record  instance;

  PStorage          Font_Buffer;

  int  num_glyphs;
  int  num_pts;
  int  num_ctr;

  Int    ptsize;

  Int           Fail;
  Int           Num;


  Bool  LoadTrueTypeChar( Int idx )
  {
    PGlyph  pG;
    Short   numP, numC;

    /* Reset_Context( instance->exec );  */
    
    if ( !Load_TrueType_Glyph( instance, idx, TRUE ) )
      return FAILURE;
  
    pG   = instance->glyph;
    numP = instance->pts.n;
    numC = instance->glyph->numberOfContours;
  
    if ( numP <= 0 || numC <= 0 )
      return FAILURE;
  
     TT_Transform_Glyph( instance ); /* This call scales the glyph */

    /* The following operations should be later included into the */
    /* Run_Context function. However, we're still debugging and   */
    /* it is important to do these things ourselves               */

     if ( !Load_Glyph_Instructions( instance, 0 ) )
       Panic1( "could not load instructions\n" );

     if ( !Run_Context( instance ) )
       return FAILURE;

    return SUCCESS;
  }


  int main( int argc, char** argv ) 
  {
    int     i;
    char    filename[128+4];
    char*   execname;

  
    Font_Buffer = (PStorage)malloc( Font_Buff_Size );
    if ( !Font_Buffer )
    {
      printf( "Error: Could not even allocate font pool!!\n" );
      exit( 1 );
    }

    Init_FontPool( Font_Buffer, Font_Buff_Size );

    num_pts = 0;
    num_ctr = 0;

    execname = argv[0];

    if ( argc != 3 )
    {
      printf( "test: simple TrueType interpreter tester - part of the FreeType project\n" );
      printf( "-----------------------------------------------------------------------\n\n" );
      printf( "Usage: %s ppem fontname[.ttf]\n\n", execname );
      exit( 1 );
    }

    if ( sscanf( argv[1], "%d", &ptsize ) == EOF )
      ptsize = 64;

    i = strlen( argv[2] );
    while ( i > 0 && argv[2][i] != '\\' )
    {
      if ( argv[2][i] == '.' )
        i = 0;
      i--;
    }

    filename[128] = 0;

    strncpy( filename, argv[2], 128 );
    if ( i >= 0 )
      strncpy( filename + strlen( filename ), ".ttf", 4 );

    if ( !TT_Open_File( filename , &stream ) )
    {
      printf( "Error, could not find/open %s\n\n", filename );
      exit( 1 );
    }

    if ( !TT_Load_Resident_Table( stream, &resident ) ) 
    {
      printf( "ERROR: Could not load data from %s\n", filename );
      exit( 1 );
    }

    num_glyphs = resident->numGlyphs;
        
    if ( !TT_Load_Instance_Data( resident, &instance ) ) 
    {
      printf( "ERROR: Could not open instance from %s\n", filename );
      exit( 1 );
    }

    if ( !Create_Context( instance ) )
      Panic1( "could not create execution context\n" );

    if ( !Reset_Context( instance, ptsize, 96 ) )
      Panic1( "could not reset execution context\n" );

    Fail = 0;

    printf( "Now executing glyphs\n" );

    for ( i = 0; i < num_glyphs; i++ )
    {

      if ( !LoadTrueTypeChar( Num ) )
      {
        printf( "glyph %4d : error = %d\n", i, instance->error );
        Fail++;
      }
    }

    TT_Close_File( stream );

    printf( "execution completed successfully\n" );
    printf( "fails  = %d\nglyphs = %d\n", Fail, num_glyphs );

    return 0;
}


/* End */
