/*******************************************************************
 *
 *  ttmutex.h                                                1.0
 *
 *    Mutual exclusion object / dummy generic interface.            
 *
 *  Copyright 1996, 1997 by
 *  David Turner, Robert Wilhelm, and Werner Lemberg.
 *
 *  This file is part of the FreeType project, and may only be used
 *  modified and distributed under the terms of the FreeType project
 *  license, LICENSE.TXT. By continuing to use, modify or distribute 
 *  this file you indicate that you have read the license and
 *  understand and accept it fully.
 *
 *  Note : This file is a generic interface. The implementation
 *         to compile depends on your system and the type of
 *         library you want to build ( either singly-threaded,
 *         thread-safe or re-entrant ).
 *
 *         Please read the technical documentation for more details
 *
 ******************************************************************/

#ifndef TTMUTEX_H
#define TTMUTEX_H

  typedef  void*  TMutex;  /* typeless reference to a mutex */

  void  Mutex_Create ( TMutex*  mutex );
  /* Create a new mutex */

  void  Mutex_Delete ( TMutex*  mutex );
  /* Delete a mutex */

  void  Mutex_Lock   ( TMutex*  mutex );
  /* Lock a mutex */

  void  Mutex_Release( TMutex*  mutex );
  /* Release a mutex */

#endif /* TTMUTEX_H */

