#define Uses_TApplication
#define Uses_TDeskTop
#define Uses_TEvent
#define Uses_TRect
#define Uses_TMenuBar
#define Uses_TMenuItem
#define Uses_TSubMenu
#define Uses_TListViewer
#define Uses_TWindow
#define Uses_TKeys
#define Uses_TScreen
#define Uses_MsgBox
#include <tv.h>

#define TPoint TT_Point
#include "freetype.h"
#include "tttypes.h"
#include "ttmemory.h"
#include "tterror.h"
#include "ttfile.h"
#include "ttcalc.h"
#include "ttdebug.h"
#include "ttraster.h"
#include "ttins.h" // should be ttins2.h ???
#include "gmain.h"
#undef TPoint

#include "codetv.h"
#include "stacktv.h"
#include "statetv.h"
#include "zonetv.h"

#include "debugger.h"

#include <stdio.h>
#include <string.h>
#include <malloc.h>

#define DEBUG_CVT

const
  Precis = 64,

  Screen_Width  = 640,
  Screen_Height = 480,
  Screen_Cols   = Screen_Width / 8,
  Screen_Size   = Screen_Cols * Screen_Height,

  Grid_Width  = Screen_Width / 16,
  Grid_Height = Screen_Height / 16,
  Grid_Cols   = Grid_Width / 8,
  Grid_Size   = Grid_Cols * Grid_Height,

  Screen_Center_X = Screen_Width / 2,
  Screen_Center_Y = Screen_Height / 2,

  Grid_Center_X = Grid_Width / 2,
  Grid_Center_Y = Grid_Height / 2,

  Profile_Buff_Size = 64000;


enum TDebug_Mode { debug_code, view_glyph };

class TMyApp :
    public TApplication
{
public:

  TMyApp();
  void NewWindow();
  static TMenuBar *initMenuBar( TRect R );
  virtual void handleEvent( TEvent &event );

  void Single_Step();
  void Execute_Loop();
  void New_Execution();
  void ReFocus();
};

enum TEtat { etat_Termine, etat_Arret, etat_Execution };

struct TVolatileBreakPoint
{
  Int  range;
  Int  address;
};

TCodeWindow   *CW;
TStackWindow  *SW;
TStateWindow  *GW;
TZoneWindow   *ZW;

PCodeRange Code_Range[3];

TRangeRec  Gen_Range[3];

Int  Old_Range;

TT_Stream  stream;

PResident_Record  resident;
PInstance_Record  instance;

#define exec ((PExecution_Context)instance->exec)

TEtat  etat;

PBreakPoint  Volatiles;

TT_PCoordinates  xCoord;
TT_PCoordinates  yCoord;
TT_PTouchTable   Flag;

TRasterBlock  Bitmap_small;
TRasterBlock  Bitmap_big;

int  display_outline;
int  hint_glyph;

TDebug_Mode  debug_mode;

Int         Range;
void       *P;
char        filename[256];
PStorage    Font_Buffer;
Int         T, I;


void Initialize()
{
  int  i;

  for (i = 0; i < 3; ++i) Code_Range[i] = Get_CodeRange(exec,i+1);
  for (i = 0; i < 3; ++i) Generate_Range( Code_Range[i], i+1, &Gen_Range[i] );

  Volatiles = NULL;

  display_outline = 1;
  debug_mode      = debug_code;
}

/*******************************************************************
 *
 *  Function    : InitRows
 *
 *  Description : Allocates the target bitmaps
 *
 *****************************************************************/

void InitRows()
{
  void  *P;

  /* The big bitmap will contain the grid, the glyph contours and */
  /* the magnified bitmap                                         */

  Bitmap_big.rows  = Screen_Height;
  Bitmap_big.cols  = Screen_Cols;
  Bitmap_big.width = Screen_Width;
  Bitmap_big.flow  = TT_Flow_Down;
  Bitmap_big.size  = Screen_Size;

  Bitmap_big.bitmap = malloc( Bitmap_big.size );
  if (!Bitmap_big.bitmap)
  {
    fprintf(stderr, "ERREUR:InitRows:Not enough memory to allocate big BitMap");
    exit(1);
  }

  /* The small bitmap contains the rendered glyph, and is then later */
  /* magnified into the big bitmap                                   */

  Bitmap_small.rows  = Grid_Height;
  Bitmap_small.cols  = Grid_Cols;
  Bitmap_small.width = Grid_Width;
  Bitmap_small.flow  = TT_Flow_Down;
  Bitmap_small.size  = Grid_Size;

  Bitmap_small.bitmap = malloc( Bitmap_small.size );
  if (!Bitmap_small.bitmap)
  {
    fprintf(stderr, "ERREUR:InitRows:Not enough memory to allocate small BitMap");
    exit(1);
  }

  /* Note that the render pool should be allocated from the font pool */
  /* for various debugging reasons, and because we're still in alpha, */
  /* we don't do it yet..                                             */

  P = malloc( Profile_Buff_Size );
  if (!P)
  {
    fprintf(stderr, "ERREUR:InitRows:Not enough memory to allocate render pool");
    exit(2);
  }

#if 0
  Init_Rasterizer( P,
                   Profile_Buff_Size,
                   NULL,
                   0 );
#else
  InitRasterizer( (PLong)P, Profile_Buff_Size, NULL, 0 );
#endif

  memset( Bitmap_big.bitmap, 0, Bitmap_big.size );
  memset( Bitmap_small.bitmap, 0, Bitmap_small.size );
}

/*******************************************************************
 *
 *  Function    :  ClearData
 *
 *  Description :  Clears the bitmaps
 *
 *****************************************************************/

void ClearData()
{
  memset( Bitmap_big.bitmap, 0, Bitmap_big.size );
  memset( Bitmap_small.bitmap, 0, Bitmap_small.size );
}

Bool Render_Magnified()
{
  typedef char TBlock[8];
  typedef char *PBlock;

  static TBlock Grid_Pixel2
              = { 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0x00 };

  static const Pixel_Center_X = 3;
  static const Pixel_Center_Y = 3;

  static TBlock Grid_Empty
             = { 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00 };

  static TBlock Grid_Pixel1
              = { 0x00, 0x00, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00 };

  static const Big_Center_X = Grid_Center_X*16 + Pixel_Center_X;
  static const Big_Center_Y = Grid_Center_Y*16 + Pixel_Center_Y;

  int r, w, w2, u, v, b, c;

  Long x, y;

  PBlock  block;
  TGlyphRecord  G;

  PBlock  pixel, empty;

  int numPoints;

  numPoints = instance->pts.n - 2; /* Remove phantom points */

  for (r = 0; r < numPoints; ++r)
  {
    xCoord[r] = instance->pts.cur_x[r] + 31;
    yCoord[r] = instance->pts.cur_y[r] + 31;
    Flag[r]   = instance->pts.touch[r] & 1;
  }

  /* We begin rendering the glyph within the small bitmap */

  G.outlines  = instance->numContours;
  G.outStarts = instance->endContours;
  G.points    = numPoints;
  G.xCoord    = xCoord;
  G.yCoord    = yCoord;
  G.flag      = Flag;

  if (!Render_Glyph ( &G, &Bitmap_small, 2 )) goto Exit_1;

  /* Then, we render the glyph outline in the bit bitmap */

  for (r = 0; r < numPoints; ++r)
  {
    x = xCoord[r]-31;
    y = yCoord[r]-31;

    x = (x - Precis*Grid_Center_X)*16 + Big_Center_X*Precis;
    y = (y - Precis*Grid_Center_Y)*16 + Big_Center_Y*Precis;

    xCoord[r] = x + 8*64;
    yCoord[r] = y + 8*64;
  }

   /* first compute the magnified coordinates */

  G.outlines  = instance->numContours;
  G.outStarts = instance->endContours;
  G.points    = numPoints;
  G.xCoord    = xCoord;
  G.yCoord    = yCoord;
  G.flag      = Flag;

  if (display_outline)
    if (!Render_Glyph ( &G, &Bitmap_big, 2 )) goto Exit_1;

  /* Now, magnify the small bitmap, XORing it to the big bitmap */

  r = 0;
  w = 0;
  b = 0;

  empty = Grid_Empty;

  pixel = display_outline ? Grid_Pixel1 : Grid_Pixel2;

  for (y = 0; y < Grid_Height; ++y)
  {
    for (x = 0; x < Grid_Width; ++x)
    {
      w2 = w;
      b  = b >> 1;

      if (b == 0)
      {
        c = ((PByte)Bitmap_small.bitmap)[r];
        b = 0x80;
        ++r;
      }

      block = (c & b) ? pixel : empty;

      for (v = 0; v < 8; ++v)
      {
        ((PByte)Bitmap_big.bitmap)[w2] = ((PByte)Bitmap_big.bitmap)[w2]
                                         ^ block[v];
        w2 += Bitmap_big.cols;
      }

      w += 2;

    }

    w += 15*Screen_Cols;

  }


  /* Display the resulting big bitmap */

  Display_Bitmap_On_Screen( (char *) Bitmap_big.bitmap, 450, 80  );

Exit_1:
  /* Clear the bitmaps */

  ClearData();

  return TRUE;
}


void Exit_Viewer()
{
  RestoreScreen();
  debug_mode = debug_code;
  TProgram *app = TApplication::application;
  app->setScreenMode( TDisplay::smCO80 + TDisplay::smFont8x8 );
  app->show();
  app->redraw();
}


void Enter_Viewer()
{
  SetGraphScreen( Graphics_Mode_Mono );

  if (!Render_Magnified())
    Exit_Viewer();
  else
    debug_mode = view_glyph;
}


void TMyApp::Execute_Loop()
{
  int Out;
  PBreakPoint B;

  Out  = 0;
  etat = etat_Execution;

  do
  {
    Single_Step();

    B = Find_BreakPoint( Volatiles, exec->curRange, exec->IP );
    if (B)
    {
      Clear_Break( &Volatiles, B );
      Out = 1;
    }

    if (etat == etat_Execution)
    {
      B = Find_BreakPoint( Gen_Range[exec->curRange-1].Breaks,
			   exec->curRange,
			   exec->IP );
      if (B)
      {
	Out  = 1;
	etat = etat_Arret;
      }
    }
    else
      Out = 1;
  }
  while (!Out);

}


void TMyApp::New_Execution()
{
  TEvent Event;

  Event.what    = evWave;
  Event.message.command = cmNewExecution;

  handleEvent( Event );
}


void TMyApp::Single_Step()
{

  if (!RunIns( exec ))
  {
    etat = etat_Termine;
#if 0
    messageBox( mfError+mfOKButton, "Error : %s", TT_ErrorStr );
#else
    messageBox( mfError+mfOKButton, "Error : %d", Error );
#endif
    return;
  }

  if (exec->IP >= exec->codeSize)
  { 
    if (exec->curRange != TT_CodeRange_Cvt ||
	! Goto_CodeRange( exec, TT_CodeRange_Glyph, 0 ))
    {
      etat = etat_Termine;
      messageBox( "Completed", mfInformation+mfOKButton );
      return;
    }
  }
}


void TMyApp::ReFocus()
{
  TEvent  Event;

  Event.what    = evCommand;

  if (Old_Range != exec->curRange)
  {
    Old_Range     = exec->curRange;
    Event.message.command = cmChangeRange;
    Event.message.infoPtr = &Gen_Range[Old_Range-1];
    CW->handleEvent( Event );
  }

  Event.what    = evWave;
  Event.message.command = cmReFocus;

  if (etat != etat_Termine)
    Event.message.infoInt = Get_Dis_Line( &Gen_Range[Old_Range-1], exec->IP );
  else
    Event.message.infoInt = -1;

  handleEvent( Event );
}


void TMyApp::NewWindow()
{
  TRect  R;
  TRangeRec RR;

  R = deskTop->getExtent();
  R.b.x = 32;

  Old_Range = exec->curRange;

  CW = new TCodeWindow( R, &Gen_Range[Old_Range-1] );
  deskTop->insert(CW);

  R = deskTop->getExtent();
  R.a.x = 32;
  R.b.x = 50;
  R.b.y = R.b.y / 2;

  SW = new TStackWindow( R, exec );
  deskTop->insert(SW);

  R = deskTop->getExtent();
  R.a.x = 50;
  R.b.y = R.b.y / 2;

  GW = new TStateWindow( R, exec );
  deskTop->insert(GW);

  R = deskTop->getExtent();
  R.a.x = 32;
  R.a.y = R.b.y / 2;

#ifdef DEBUG_CVT
  ZW = new TZoneWindow( R, &instance->twilight );
#else
  ZW = new TZoneWindow( R, &instance->pts );
#endif
  deskTop->insert(ZW);

  etat = etat_Arret;
}


TMenuBar * TMyApp::initMenuBar( TRect R )
{
  R.b.y = R.a.y + 1;
  return new TMenuBar( R,
    *new TSubMenu( "~F~ile", kbAltF ) +
       *new TMenuItem( "~O~pen", cmFileOpen, kbF3, hcNoContext, "F3" ) +
    *new TSubMenu( "~R~un", kbAltR ) +
       *new TMenuItem( "~R~un", cmRun, kbCtrlF9, hcNoContext, "Ctrl-F9" ) +
       *new TMenuItem( "~G~o to cursor", cmGotoCursor, kbF4,
		       hcNoContext, "F4" ) +
       *new TMenuItem( "~T~race into", cmTraceInto, kbF7,
		       hcNoContext, "F7" ) +
       *new TMenuItem( "~S~tep over", cmStepOver, kbF8, hcNoContext, "F8" ) +
       *new TMenuItem( "~V~iew glyph", cmViewGlyph, kbF9, hcNoContext, "F9" ) +
    *new TSubMenu( "~W~indow", kbAltW ) +
       *new TMenuItem( "~N~ext", cmNext, kbF6, hcNoContext, "F6" )
    );
}


void TMyApp::handleEvent( TEvent &event )
{
  Long  Adr;

  if (debug_mode == view_glyph)
  {
    switch (event.what)
    {
    case evKeyDown :

      switch (event.keyDown.keyCode)
      {
      case kbF2 :
	{
	  display_outline = ! display_outline;

	  if (!Render_Magnified())
	    Exit_Viewer();
	}
	break;

      case kbEsc : Exit_Viewer(); break;
      }
    }
    clearEvent( event );
    return;
  }

  TApplication::handleEvent(event);

  switch (event.what)
  {
  case  evCommand :

    switch (event.message.command)
    {
    case cmNewWin : NewWindow(); break;

    case cmGotoCursor :
      {
	if (etat == etat_Termine)
	  return;

	event.message.command = cmQueryCursorAddr;
	event.message.infoPtr = &Adr;

	CW->handleEvent( event );

	Set_Break( &Volatiles,
		   exec->curRange,
		   Adr );

	New_Execution();
	Execute_Loop();
	ReFocus();
      }
      break;

    case cmTraceInto :
      {
	if (etat == etat_Termine)
	  return;

	New_Execution();
	Single_Step();
	ReFocus();
      }
      break;

    case cmStepOver :
      {
	if (etat == etat_Termine)
	  return;

	New_Execution();
	switch (exec->code[exec->IP])
	{
	case 0x2A :  /* LOOPCALL */
	case 0x2B : /* CALL     */
	  {
	    Set_Break( &Volatiles,
		       exec->curRange,
		       exec->IP + Get_Length( exec->code,
                                                  exec->IP ) );
	    Execute_Loop();
	  }
	default :
	  Single_Step();
	  break;
	}
	ReFocus();
      }

    case cmViewGlyph :
      Enter_Viewer();
      break;

    default :
      return;
    }

  default:
    return;
  }

  clearEvent(event);
}


TMyApp::TMyApp() :
  TProgInit( &TMyApp::initStatusLine,
	     &TMyApp::initMenuBar,
	     &TMyApp::initDeskTop )
{
  setScreenMode( TDisplay::smCO80 + TDisplay::smFont8x8 );
  NewWindow();
}



/*******************************************************************
 *
 *  Function    :  LoadTrueTypeChar
 *
 *  Description :
 *
 *  Notes  :
 *
 *****************************************************************/

Bool LoadTrueTypeChar( int idx )
{
  long  x, y;
  int  j;
  float  CR, SR;

  int numPoints, numContours;

#if 0
  if ( !TT_Load_Glyph( instance, idx, TRUE ) ) return FALSE;
#else
  if ( !Load_TrueType_Glyph( instance, idx, TRUE ) ) return FALSE;
#endif

  numPoints   = instance->pts.n;
  numContours = instance->numContours;

  if (numPoints <= 0 || numContours <= 0) return FALSE;

  /* Now compute the scaled glyph point coordinates */

  /* no rotation nor strecth there */

  for (j = 0; j < numPoints; ++j)
  {
    x = MulDiv_Round( instance->pts.org_x[j], exec->scale1, exec->scale2 );
    y = MulDiv_Round( instance->pts.org_y[j], exec->scale1, exec->scale2 );

    instance->pts.org_x[j] = x;
    instance->pts.org_y[j] = y;
    instance->pts.cur_x[j] = x;
    instance->pts.cur_y[j] = y;
  }

  return TRUE;
}


int main(int argc, char **argv)
{
  if (argc != 2)
  {
    fprintf(stderr, "Simple Library Debugger -- part of the FreeType project\n");
    fprintf(stderr, "-----------------------------------------------------\n");
    fprintf(stderr, "\n");
    fprintf(stderr, " Usage :  debugger fontfile[.ttf]\n");
    fprintf(stderr, "\n");
    return (2);
  }

  strcpy( filename, argv[1] );
  if (!strchr( filename, '.' )) strcat( filename, ".ttf" );

  Font_Buffer = (PStorage) malloc( 64000 );
  Init_FontPool( Font_Buffer, 64000 );

  if (!TT_Open_File( filename, &stream ))
  {
    fprintf(stderr, "Could not open file %s\n",filename );
    return(1);
  }

  if (! TT_Load_Resident_Table( stream, &resident ) )
  {
    fprintf(stderr, "Could not load resident table\n" );
    return(1);
  }

  fprintf(stderr, "OK\n");

  fprintf(stderr, "Resident Table Size = %ld\n", resident->totalSize );

  if (!TT_Load_Instance_Data( resident, &instance ) )
  {
    fprintf(stderr, "Could not create instance table\n" );
    return(1);
  }

  int i = resident->maxProfile.maxPoints;

  xCoord = (TT_PCoordinates) malloc( sizeof(TT_Fixed) * i );
  yCoord = (TT_PCoordinates) malloc( sizeof(TT_Fixed) * i );
  Flag = (TT_PTouchTable) malloc( i );


  fprintf(stderr, "Instance Data Size  = %ld\n", instance->totalSize );

#if 0
  TT_Reset_Instance( instance, 8, 96 ); // ???
#endif

  if ( !Create_Context( instance ) )
  {
    fprintf(stderr, "could not create execution context\n" );
    return(1);
  }

  if ( !Reset_Context( instance, 8 /* pointsize */, 96 ) )
  {
    fprintf(stderr, "could not reset execution context\n" );
    return(1);
  }

  if (! Goto_CodeRange( exec, TT_CodeRange_Font, 0 ) )
  {
    fprintf(stderr, "Could not go to font program\n" );
    return(1);
  }

  if (! RunIns( exec ) )
  {
    fprintf(stderr, "Error while running font program\n" );
    return(1);
  }

  if (! Goto_CodeRange( exec, TT_CodeRange_Cvt, 0 ) )
  {
    fprintf(stderr, "Could not go to CVT program\n" );
    return(1);
  }

#ifndef DEBUG_CVT

  if (! RunIns( instance ) )
  {
    fprintf(stderr, "Error while running CVT program\n" );
    fprintf(stderr, "%s\n", TT_ErrorStr );
    return(1);
  }

  TT_Set_Glyph_Defaults( instance );

  if (! LoadTrueTypeChar( 54 ) )
  {
    fprintf(stderr, "Error while loading glyph\n" );
    return(1);
  }


  Set_CodeRange( instance, 3, instance->glyphIns, instance->glyphSize );

  if (! Goto_CodeRange( instance, TT_CodeRange_Glyph, 0 ) )
  {
    fprintf(stderr, "Could not go to glyph instructions\n" );
    return(1);
  }

  TT_Glyph_Defaults( instance );

  instance->pts.org_x[n-2] = ((instance->pts.org_x[n-2]+32) and -64);
  instance->pts.org_x[n-1] = ((instance->pts.org_x[n-1]+32) and -64);
  instance->pts.cur_x[n-2] = instance->pts.org_x[n-2];
  instance->pts.cur_x[n-1] = instance->pts.org_x[n-1];


#endif

  exec->instruction_trap = 1;

  Initialize();
  InitRows();

  {
    TMyApp myapp;
    myapp.run();
  }

  TT_Close_File( stream );
 
  return 0;
}
