#define Uses_TEvent
#define Uses_TRect
#define Uses_TListViewer
#define Uses_TWindow
#define Uses_TKeys
#define Uses_TScrollBar
#include <tv.h>

#define TPoint TT_Point
#include "freetype.h"
#include "tttypes.h"
#include "tttables.h"
#include "ttdebug.h"
#undef TPoint

#include "codetv.h"
#include "debugger.h"

#include <stdio.h>

/*
 * TCodeViewer
 */

TCodeViewer::TCodeViewer( const TRect &bounds, PRangeRec ARange ) :
  TListViewer( bounds, 1, NULL, NULL )
{
  growMode  = gfGrowHiX | gfGrowHiY;
  dragMode  = dmDragGrow | dmLimitLoX | dmLimitLoY;
  eventMask |= evWave;

  IP = 0;

  Change_Range( ARange );
}

void TCodeViewer::Change_Range( PRangeRec ARange )
{
  codeRange = ARange;

  if (codeRange)
    setRange( codeRange->NLines );
  else
    setRange( 0 );
}

void TCodeViewer::Change_Focus( int ALine )
{

  if (ALine < 0)
  {
    IP = -1;
    drawView();
    return;
  }

  if (ALine >= topItem + size.y) topItem = ALine;

  if (codeRange)
  {
    focusItem( ALine );
    IP = codeRange->Disassembled[ALine];
  }
  drawView();
}


void TCodeViewer::Get_Cursor_Addr( PLong P )
{
  if (focused < 0 || focused >= codeRange->NLines)
    P[0] = -1;
  else
    P[0] = codeRange->Disassembled[focused];
}


void TCodeViewer::handleEvent( TEvent &event )
{
  TRect  Limits;
  TPoint Mini, Maxi;

  TListViewer::handleEvent(event);

  switch (event.what)
  {
  case evCommand :

    switch (event.message.command)
    {
    case cmChangeRange :
      Change_Range( (PRangeRec) event.message.infoPtr );
      break;

    case cmQueryCursorAddr :
      Get_Cursor_Addr( (PLong) event.message.infoPtr );
      break;

    case cmResize:
      Limits = owner->getExtent();
      sizeLimits( Mini, Maxi );
      dragView(event, dragMode, Limits, Mini, Maxi );
      clearEvent(event);
      break;
    }

    case evWave :
      if (event.message.command == cmReFocus)
	Change_Focus( event.message.infoInt );
      break;
  };
}


void TCodeViewer::draw()
{
  static const uchar Colors[4] = {0x1E,0x40,0x0E,0x30};
  static const char Prefix[4] = { 0, 'f', 'c', 'g' };

  int I, J, Item;
  TDrawBuffer B;
  char S[2100];
  int Indent, Ligne;

  unsigned Color;

  int On_BP;
  PBreakPoint BP;

#if 0
  Colors[0] := GetColor(1);  /* Normal line */
  Colors[1] := GetColor(2);  /* Normal breakpoint */
  Colors[2] := GetColor(3);  /* Focused line */
  Colors[3] := GetColor(4);  /* Focused breakpoint */
#endif

  if (hScrollBar)
    Indent = hScrollBar->value;
  else
    Indent = 0;

  BP = codeRange->Breaks;

  if (BP && codeRange->NLines > topItem)
    while (BP && BP->Address < codeRange->Disassembled[topItem])
      BP = BP->Next;

  for (I = 0; I < size.y; ++I)
  {
    Item = topItem + I;

    Color = 0;

    if (Item < codeRange->NLines)
    {
      Ligne = codeRange->Disassembled[Item];

      if (BP && BP->Address == Ligne)
      {
        Color = 1;
	do
	  BP = BP->Next;
	while (BP && BP->Address <= Ligne);
      }

      if (range > 0 && focused == Item )
        Color |= 2;

      sprintf( S, " %s", Cur_U_Line( codeRange->Code, Ligne ) );

      S[1] = Prefix[codeRange->Index];

      // FIXME!! S := copy( S, 1 + Indent, Self.Size.X );

      if (Ligne == IP)
      {
	S[0] = '=';
	S[6] = '>';
      }
    }
    else
    {
       S[0] = '\0';
    }

    Color = Colors[Color];

    B.moveChar( 0, ' ', Color, size.x );
    S[maxViewWidth] = 0; /* Ugh! no buffer overrun checks in moveStr! */
    B.moveStr( 0, S, Color );

    writeLine( 0, I, size.x, 1, B );
  }
}


/*
 * TCodeWindow
 */

TCodeWindow::TCodeWindow( const TRect &bounds, PRangeRec ARange ) :
  TWindow( bounds, "Code", wnNoNumber ),
  TWindowInit( &TCodeWindow::initFrame )
{
  TRect  Bounds = getExtent();
  Bounds.grow(-1,-1);
  CodeView = new TCodeViewer( Bounds, ARange );
  insert( CodeView );
}
