/*fixpdf - get rid of colorspace problem */
/*jtdidit - jt@jt-mj.net 20 Feb - 10 Mar 2002 */


call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

tempout='$$$.PDF' 
iccb='/ICCBased '
lev='0.3'
prog='fixpdf'
dayte='10 Mar 2002'

say prog lev dayte 
                
fix. = ''                           
fix.1="/DeviceGray"
fix.3="/DeviceRGB"
fix.4="/DeviceCMYK"
                            
parse arg infile outfile .
if infile='' then do
   say 'Usage is fixpdf infile [outfile]'
   say 'If outfile absent, fix is written back to infile'
   say 'Fixes colorspace problem for Acroread 3'
   exit
   end
infilq=infile

   
if left(infile,1)='"' then do
   parse arg instring
   q=pos('"',instring,2)
   infile=left(instring,q-1)
   infilq=left(instring,q)
   infile=substr(infile,2)
   instring=strip(substr(instring,q+1))
   if left(instring,1)='"' then do
       q=pos('"',instring,2)
       outfile=left(instring,q-1)
       outfile=substr(outfile,2)
       end
   else outfile=word(instring,1)
   end
   
   
                   
if outfile='' then outfile=tempout 


ofe=stream(outfile,'C','QUERY EXISTS')
if ofe >'' & outfile <> tempout then do
  say 'output file' outfile 'exists'
  say 'enter to replace it, anything else to quit'
  pull stuff
  if stuff <>'' then exit
  end

call sysfiledelete outfile

                         
       
ife=stream(infile,'C','QUERY EXISTS')
if ife='' then do
   say 'input file' infile 'not there.'
   say 'Filenames with spaces must be enclosed in double quotes:"this stuff.pdf"'
   exit 
   end
insize=chars(infile)   
say 'size of' infile 'is' insize 'bytes'  
  
signal on notready


filx=charin(infile,1,insize)
call charout infile
      
 

j=1  /* index to stem variables */     
 
icc.0=0
i=1

do forever
     slash=pos(iccb,filx,i)
     if slash=0 then leave
     fixpoint=pos('[',filx,slash-8)
     icc.j=fixpoint
     k=pos(']',filx,slash+10)
     i=k
     len.j=k-fixpoint+1
     stuff=substr(filx,fixpoint,len.j)
     obj.j=stuff
     icc.0=j
     j=j+1
  end
  
call charout infile  /* close it */
if icc.0=0 then do
   say 'nothing to do'
   call sysfiledelete outfile
   exit
   end

say 'done first pass -' icc.0 ' instance[s] to be fixed'

do j=1 to icc.0
   z=pos('/',obj)
   obj=substr(obj.j,z+14,30)
   z=pos('R',obj)
   obj=left(obj,z-1)||'obj' 
   k=pos(obj,filx,1)
   n=pos('/N',filx,k)
   nx=substr(filx,n+3,1)
   if fix.nx='' then do
      say "bad colorspace N" nx "- can't continue"
      signal quit
      end   
    fix=substr(fix.nx,1,len.j)
    filx=left(filx,icc.j-1)||fix||substr(filx,icc.j+len.j)
    say 'Replaced with' fix
   end
   
call charout outfile,filx,1
call charout outfile   

if outfile=tempout then do
    z=pos('.PDF',translate(infilq))
    if z>0 then bakfil=left(infilq,z-1)||'.bak'||substr(infilq,z+4)
       else bakfil='pdf.bak'
    '@copy' infilq bakfil '>NUL'
    '@copy' outfile infilq '>NUL'
    call sysfiledelete outfile
    say 'Old input file saved as' bakfil
    end

exit

quit:

call charout infile  /* close it */
call sysfiledelete outfile
exit

notready:

say 'notready condition at char pos' i
call charout infile
call charout outfile