/* FIRESTARTER */



call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'

call SysLoadFuncs



say

say "***********************************************************************"

say "*                                                                     *"

say "* FireStarter Configuration Program for the OS/2 Warp Server Firewall *"

say "*                                                                     *"

say "*                                                                     *"

say "* by James Blackmore                                                  *"

say "*                                                                     *"

say "* Modified by Bob Eager                                               *"

say "*                                                                     *"

say "***********************************************************************"

say

say "Follow the on-screen instructions to perform basic firewall configuration."

say

say "Press return to continue:"

pull dummy

say



/* CAPTURE DRIVE LETTER FOR VARIABLES */

capture:

say "Please type the letter of the drive OS/2 is running on:"

pull drive



/* INSTANTIATE VARIABLES */

file = drive":\CONFIG.SYS"

filters = drive":\MPTN\ETC\SECURITY\FWFILTRS.CNF"

interfaces = drive":\MPTN\ETC\FWSECAD.CNF"

logfile = drive":\MPTN\ETC\FWLOG.CNF"

setup = drive":\TCPIP\BIN\TCPEXIT.CMD"

copyfile = drive":\TCPIP\BIN\TCPEXIT.TMP"

basefile = substr(setup, lastpos('\', setup)+1)

init = "cfgfilt -u -i"

toggle1 = "inetcfg -s firewall 1"

toggle0 = "inetcfg -s firewall 0"



line_array.1 = "DEVICE="drive":\MPTN\PROTOCOL\IPSEC.SYS"

line_array.2 = "DEVICE="drive":\MPTN\PROTOCOL\FWIP.SYS"



say

say "Checking for device drivers in" drive":\CONFIG.SYS...."

say



/* SEARCH FILE FOR LINES IN LINE_ARRAY

    AND PUT RESULTS IN LIST */

do i = 1 to 2

    call SysFileSearch line_array.i, file, "result."

    list.i = result.0

end



/* IF LINE NOT IN FILE, ADD IT AND ALERT USER */

do j = 1 to 2

    if list.j = 0 then

        do

            call lineout file, line_array.j

            say "Line added:" line_array.j

        end

    else say "Line already present:" line_array.j

end



/* SEARCH FOR AND/OR CREATE FILTER RULES CONFIGURATION FILE */

say

say "Searching for filter rules configuration file....."

if stream(filters,'c','query exists') = "" then

    do

        say "File not found"

        say "Creating filter rules conifguration file....."

        call stream filters,'c','open'

        call stream filters,'c','close'

        say "File created:" filters

    end

else say "File already exists:" filters



/* SEARCH FOR AND/OR CREATE INTERFACES CONFIGURATION FILE */

say

say "Searching for interfaces configuration file....."

if stream(interfaces,'c','query exists') = "" then

    do

        say "File not found"

        say "Creating interfaces configuration file....."

        call stream interfaces,'c','open'

        call stream interfaces,'c','close'

        say "File created:" interfaces

    end

else say "File already exists:" interfaces

    

/* SEARCH FOR AND/OR CREATE LOG CONFIGURATION FILE */

say

say "Searching for log configuration file....."

if stream(logfile,'c','query exists') = "" then

    do

        say "File not found"

        say "Creating log configuration file....."

        call stream logfile,'c','open'

        call stream logfile,'c','close'

        say "File created:" logfile

    end

else say "File already exists:" logfile



/* DEFINE SECURE INTERFACES */

say

say "Would you like to define a secure interface now? (y/n)"

pull answer

if answer = "Y" then signal secure

else signal jump1



secure:

say

say "Type the IP address (in dotted decimal form) of the interface to be made secure:"

parse pull address

number = linein(interfaces,1)

call stream interfaces,'c','close'  /* MUST CLOSE HERE OTHERWISE 

                                                SYSFILESEARCH WON'T WORK LATER */



if number = "" then   /* BECAUSE IF FILE EMPTY SYSFILESEARCH WON'T WORK */

    do

        call lineout interfaces, address

        say

        say address "is now secure"

        say

        say "Define another? (y/n)"

        pull input

        if input = "Y" then signal secure

        else nop

    end

else  /* IF FILE ISN'T EMPTY */

    do

        call SysFileSearch address, interfaces, "intf."

        if intf.0 = 0 then                       /* IF LINE ISN'T PRESENT ADD IT */

             do

                 call lineout interfaces, address 

                 say address "is now secure."

                 say "Define another? (y/n)"

                 pull input

                 if input = "Y" then signal secure

                 else nop

             end

        else 

            do

                say "That address is already secure."

                say "Define another? (y/n)"

                pull input

                if input = "Y" then signal secure

                else nop

            end

    end





jump1:



/* SET LOGGING LEVEL */

logchoice:

say

say "Set packet logging level - options:"

say

say "10 = Debug"

say "20 = Informational"

say "30 = Warning"

say "40 = Errors"

say "50 = Alert"

say

say "State preference (10/20/30/40/50)"

parse pull level

select

    when level = 10 then signal setlog

    when level = 20 then signal setlog

    when level = 30 then signal setlog

    when level = 40 then signal setlog

    when level = 50 then signal setlog

    otherwise

        do

            say

            say "Invalid level!"

            signal logchoice

        end

end



setlog:

do   /* IF CHOICE IS SAME AS IS ALREADY SET, DO NOTHING, OTHERWISE CHANGE IT */

    call SysFileSearch level, logfile, "num."

    if num.0 = 0 then

        do

            rc = SysFileDelete(logfile)

            call stream logfile,'c','open'

            call lineout logfile, level

            call stream logfile,'c','close'

        end

    else nop

end    



/* EDIT TCPIP\BIN\TCPEXIT.CMD FILE */



/* INITIALISE FILTERS? */

say

say "Rules used on startup - options:"

say

say "1 = Firewall's default rules"

say "2 = User defined rules" 

say



cp1:

say "State preference (1/2)"

parse pull choice



if choice = "2" then     /* USE USER DEFINED RULES */

    do

        call SysFileSearch init, setup, "var."

        if var.0 = 0 then call lineout setup, init

        else nop

        r = "user defined rules"

    end

else

    if choice = "1" then            /* USE FIREWALL DEFAULT RULES */

         do

             r = "firewall's default rules"

             /* COPY ALL LINE EXCEPT THAT SPECIFIED */

             do while lines(setup) > 0         

                 current_line = linein(setup)

                 if current_line = init then nop

                 else call lineout copyfile, current_line

             end   

             current_line = linein(setup)

             if current_line = init then nop

             else call lineout copyfile, current_line

             call stream copyfile,'c','close'



             /* DELETE SETUP FILE */

             call stream setup,'c','close'

             rc = SysFileDelete(setup)



             /* RENAME */

             rename copyfile basefile

             call stream setup,'c','close'

         end



    else signal cp1               /* CATCHES ANY OTHER INPUT */



/* FIREWALL STATUS? */

cp2:

say

say "Firewall status on startup? (on/off)"

parse pull status

if status = "on" then 



    do                            /* IF FIREWALL IS ON DO NOTHING, ELSE.... */

        s = "on"

        booleanB = 0

        call SysFileSearch setup, toggle1, "tog1."

        if tog1.0 = 1 then nop

        else booleanB = 1

        if booleanB = 0 then nop

        else

             do

                 /* COPY OUT FIREWALL OFF */

                 call stream copyfile,'c','open'

                 current_line = linein(setup,1)

                 if current_line = toggle0 then nop

                 else call lineout copyfile, current_line

                 do while lines(setup) > 0         

                     current_line = linein(setup)

                     if current_line = toggle0 then nop

                     else call lineout copyfile, current_line

                 end   

                 current_line = linein(setup)

                 if current_line = toggle0 then nop

                 else call lineout copyfile, current_line

                 call stream setup,'c','close'



                 /* ADD FIREWALL ON */

                 call lineout copyfile, toggle1

                 call stream copyfile,'c','close'



                 /* DELETE SETUP FILE */

                 rc = SysFileDelete(setup)



                /* RENAME */

                rename copyfile basefile

           end

      end

else

    if status = "off" then

        do                            /* IF FIREWALL IS OFF DO NOTHING, ELSE.... */

            s = "off"

            booleanC = 0

            call SysFileSearch setup, toggle0, "tog0."

            if tog0.0 = 1 then nop

            else booleanC = 1

            if booleanC = 0 then nop

            else

                do

                    /* COPY OUT FIREWALL ON */

                    call stream copyfile,'c','open'

                    current_line = linein(setup,1)

                    if current_line = toggle1 then nop

                    else call lineout copyfile, current_line

                    do while lines(setup) > 0         

                        current_line = linein(setup)

                        if current_line = toggle1 then nop

                        else call lineout copyfile, current_line

                    end   

                    current_line = linein(setup)

                    if current_line = toggle1 then nop

                    else call lineout copyfile, current_line

                    call stream setup,'c','close'



                    /* ADD FIREWALL OFF */

                    call lineout copyfile, toggle0

                    call stream copyfile,'c','close'



                    /* DELETE SETUP FILE */

                    rc = SysFileDelete(setup)



                   /* RENAME */

                   rename copyfile basefile

              end

         end



    else signal cp2      /* CATCHES ANY OTHER INPUT */





/* PRINT A CONFIGURATION SUMMARY TO SCREEN */

say

say "Basic firewall configuration is now complete."

say

say "------------------------"

say "Firewall status summary:"

say "------------------------"

say

say "Secure interfaces:"

line_read = linein(interfaces,1)

if line_read = "" then say "none"

else say line_read                     /* SAY FIRST LINE */

do while lines(interfaces) > 0     /* SAY FROM SECOND TO LAST BUT ONE */

    line_read = linein(interfaces)

    say line_read

    end

line_read = linein(interfaces)     /* SAY LAST LINE */

say line_read

say

say "Packet logging level =" level

say

say "Firewall will use" r "on startup"

say

say "Firewall status on startup =" s

say

say "NOW RESTART YOUR COMPUTER FOR CONFIGURATION TO UPDATE"



EXIT

