//
// $Header: d:\\32bits\\ext2-os2\\misc\\rcs\\hardlink.c,v 1.1 1997/03/16 12:38:49 Willm Exp $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996, 1997  Matthieu WILLM (willm@ibm.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <os2/vfsapi.h>

void os2_err(int error) {
    int rc;
    char *buf;
    unsigned long len;


    buf = malloc(4096);
    if (buf) {
        rc = DosGetMessage(0, 0, buf, 4096, error, "OSO001.MSG", &len);
        if (rc == NO_ERROR) {
            fprintf(stderr, "%s", buf);
        }
        free(buf);
    }
}

int main(int argc, char **argv) {
    int ret;
    int rc;

    if (argc == 3) {
        rc = vfs_link(argv[1], argv[2]);
        if (rc == NO_ERROR) {
            printf("%s -> %s [OK]\n", argv[1], argv[2]);
            ret = 0;
        } else {
           fprintf(stderr, "%s -> %s [FAILED]\n", argv[1], argv[2]);
           os2_err(rc);
           ret = 1;
        }
    } else {
        fprintf(stderr, "Usage : link <oldname> <newname>\n");
        ret = 1;
    }

    return ret;
}
